/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.redis.utils;

import cn.hutool.core.collection.IterUtil;
import com.icetech.common.utils.SpringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.redisson.api.ObjectListener;
import org.redisson.api.RBatch;
import org.redisson.api.RBucket;
import org.redisson.api.RKeys;
import org.redisson.api.RList;
import org.redisson.api.RMap;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RSet;
import org.redisson.api.RTopic;
import org.redisson.api.RateIntervalUnit;
import org.redisson.api.RateType;
import org.redisson.api.RedissonClient;

public class RedisUtils {
    private static final RedissonClient CLIENT = (RedissonClient)SpringUtils.getBean(RedissonClient.class);

    public static long rateLimiter(String key, RateType rateType, int rate, int rateInterval) {
        RRateLimiter rateLimiter = CLIENT.getRateLimiter(key);
        rateLimiter.trySetRate(rateType, (long)rate, (long)rateInterval, RateIntervalUnit.SECONDS);
        if (rateLimiter.tryAcquire()) {
            return rateLimiter.availablePermits();
        }
        return -1L;
    }

    public static RedissonClient getClient() {
        return CLIENT;
    }

    public static <T> void publish(String channelKey, T msg, Consumer<T> consumer) {
        RTopic topic = CLIENT.getTopic(channelKey);
        topic.publish(msg);
        consumer.accept(msg);
    }

    public static <T> void publish(String channelKey, T msg) {
        RTopic topic = CLIENT.getTopic(channelKey);
        topic.publish(msg);
    }

    public static <T> void subscribe(String channelKey, Class<T> clazz, Consumer<T> consumer) {
        RTopic topic = CLIENT.getTopic(channelKey);
        topic.addListener(clazz, (channel, msg) -> consumer.accept(msg));
    }

    public static <T> void setCacheObject(String key, T value) {
        RedisUtils.setCacheObject(key, value, false);
    }

    public static <T> void setCacheObject(String key, T value, boolean isSaveTtl) {
        RBucket bucket = CLIENT.getBucket(key);
        if (isSaveTtl) {
            try {
                bucket.setAndKeepTTL(value);
            }
            catch (Exception e) {
                long timeToLive = bucket.remainTimeToLive();
                bucket.set(value);
                bucket.expire(timeToLive, TimeUnit.MILLISECONDS);
            }
        } else {
            bucket.set(value);
        }
    }

    public static <T> void setCacheObject(String key, T value, long timeout, TimeUnit timeUnit) {
        RBucket result = CLIENT.getBucket(key);
        result.set(value);
        result.expire(timeout, timeUnit);
    }

    public static <T> void addObjectListener(String key, ObjectListener listener) {
        RBucket result = CLIENT.getBucket(key);
        result.addListener(listener);
    }

    public static boolean expire(String key, long timeout) {
        return RedisUtils.expire(key, timeout, TimeUnit.SECONDS);
    }

    public static boolean expire(String key, long timeout, TimeUnit unit) {
        RBucket rBucket = CLIENT.getBucket(key);
        return rBucket.expire(timeout, unit);
    }

    public static <T> T getCacheObject(String key) {
        RBucket rBucket = CLIENT.getBucket(key);
        return (T)rBucket.get();
    }

    public static <T> long getTimeToLive(String key) {
        RBucket rBucket = CLIENT.getBucket(key);
        return rBucket.remainTimeToLive();
    }

    public static boolean deleteObject(String key) {
        return CLIENT.getBucket(key).delete();
    }

    public static void deleteObject(Collection collection) {
        RBatch batch = CLIENT.createBatch();
        collection.forEach(t -> batch.getBucket(t.toString()).deleteAsync());
        batch.execute();
    }

    public static <T> boolean setCacheList(String key, List<T> dataList) {
        RList rList = CLIENT.getList(key);
        return rList.addAll(dataList);
    }

    public static <T> void addListListener(String key, ObjectListener listener) {
        RList rList = CLIENT.getList(key);
        rList.addListener(listener);
    }

    public static <T> List<T> getCacheList(String key) {
        RList rList = CLIENT.getList(key);
        return rList.readAll();
    }

    public static <T> boolean setCacheSet(String key, Set<T> dataSet) {
        RSet rSet = CLIENT.getSet(key);
        return rSet.addAll(dataSet);
    }

    public static <T> void addSetListener(String key, ObjectListener listener) {
        RSet rSet = CLIENT.getSet(key);
        rSet.addListener(listener);
    }

    public static <T> Set<T> getCacheSet(String key) {
        RSet rSet = CLIENT.getSet(key);
        return rSet.readAll();
    }

    public static <T> void setCacheMap(String key, Map<String, T> dataMap) {
        if (dataMap != null) {
            RMap rMap = CLIENT.getMap(key);
            rMap.putAll(dataMap);
        }
    }

    public static <T> void addMapListener(String key, ObjectListener listener) {
        RMap rMap = CLIENT.getMap(key);
        rMap.addListener(listener);
    }

    public static <T> Map<String, T> getCacheMap(String key) {
        RMap rMap = CLIENT.getMap(key);
        return rMap.getAll(rMap.keySet());
    }

    public static <T> void setCacheMapValue(String key, String hKey, T value) {
        RMap rMap = CLIENT.getMap(key);
        rMap.put((Object)hKey, value);
    }

    public static <T> T getCacheMapValue(String key, String hKey) {
        RMap rMap = CLIENT.getMap(key);
        return (T)rMap.get((Object)hKey);
    }

    public static <T> T delCacheMapValue(String key, String hKey) {
        RMap rMap = CLIENT.getMap(key);
        return (T)rMap.remove((Object)hKey);
    }

    public static <K, V> Map<K, V> getMultiCacheMapValue(String key, Set<K> hKeys) {
        RMap rMap = CLIENT.getMap(key);
        return rMap.getAll(hKeys);
    }

    public static Collection<String> keys(String pattern) {
        Iterable iterable = CLIENT.getKeys().getKeysByPattern(pattern);
        return IterUtil.toList((Iterable)iterable);
    }

    public static Boolean hasKey(String key) {
        RKeys rKeys = CLIENT.getKeys();
        return rKeys.countExists(new String[]{key}) > 0L;
    }

    private RedisUtils() {
    }
}

