package com.icetech.redis.lock.anno;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Description redis 分布式锁
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2022/4/19 11:36
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
public @interface RedisLock {

    /**
     * 分布式锁key
     */
    String lockKey() default "";

    /**
     * 等待时间(秒)
     */
    int lockWaitTime() default 5;

    /**
     * 默认锁失效时间(秒)
     */
    int lockLeaseTime() default 10;
}
