/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.redis.lock;

import cn.hutool.core.date.DateUtil;
import com.icetech.redis.lock.RedissonLockException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonDistributedLock {
    private static final Logger log = LoggerFactory.getLogger(RedissonDistributedLock.class);
    private RedissonClient redissonClient;
    private int defaultLockWaitTime = 5;
    private int defaultLockLeaseTime = 10;

    public RedissonClient getRedisson() {
        return this.redissonClient;
    }

    public RedissonDistributedLock(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    public RLock getLock(String name) {
        return this.getRedisson().getLock(name);
    }

    public <T> T locked(Supplier<T> supplier, String key) throws Exception {
        return this.locked(supplier, key, this.defaultLockWaitTime, this.defaultLockLeaseTime);
    }

    public <T> T locked(Supplier<T> supplier, String key, int lockWaitTime, int lockLeaseTime) {
        return this.locked(supplier, key, lockWaitTime, lockLeaseTime, null);
    }

    public <T> T locked(Supplier<T> supplier, String key, Supplier<T> errorSupplier) {
        return this.doLocked(supplier, key, this.defaultLockWaitTime, this.defaultLockLeaseTime, errorSupplier);
    }

    public <T> T locked(Supplier<T> supplier, String key, int lockWaitTime, int lockLeaseTime, Supplier<T> errorSupplier) {
        return this.doLocked(supplier, key, lockWaitTime, lockLeaseTime, errorSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T doLocked(Supplier<T> supplier, String key, int lockWaitTime, int lockLeaseTime, Supplier<T> errorSupplier) {
        lockWaitTime = lockWaitTime < 0 ? this.defaultLockWaitTime : lockWaitTime;
        lockLeaseTime = lockLeaseTime < 0 ? this.defaultLockLeaseTime : lockLeaseTime;
        RedissonClient redisson = this.getRedisson();
        RLock lock = redisson.getLock(key);
        boolean locked = false;
        try {
            locked = lock.tryLock((long)lockWaitTime, (long)lockLeaseTime, TimeUnit.SECONDS);
            if (!locked) {
                log.info("\u5206\u5e03\u5f0f\u9501\u7b49\u5f85\u8d85\u65f6! \u7b49\u5f85\u65f6\u957f:{},\u5f53\u524d\u65f6\u95f4\u4e3a:{}", (Object)this.defaultLockWaitTime, (Object)DateUtil.date());
                if (Objects.isNull(errorSupplier)) {
                    throw new RedissonLockException("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
                }
                T t = errorSupplier.get();
                return t;
            }
            T t = supplier.get();
            return t;
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
    }
}

