/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.redis.handle;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.constants.RedisKeyConstants;
import com.icetech.common.domain.P2cBaseMsg;
import com.icetech.common.domain.WebSocketMessage;
import com.icetech.common.domain.response.ObjectResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class IceProxyMsgHandle {
    private static final Logger log = LoggerFactory.getLogger(IceProxyMsgHandle.class);
    public StringRedisTemplate stringRedisTemplate;

    @Autowired
    public void init(RedisConnectionFactory connectionFactory) {
        StringRedisTemplate stringTemplate = new StringRedisTemplate();
        stringTemplate.setConnectionFactory(connectionFactory);
        stringTemplate.afterPropertiesSet();
        this.stringRedisTemplate = stringTemplate;
    }

    public ObjectResponse<Boolean> sendSocketMsg(P2cBaseMsg p2cBaseMsg) {
        try {
            log.info("\u6d88\u606f\u53d1\u653e\u5185\u5bb9,{}", (Object)JSONUtil.toJsonStr((Object)p2cBaseMsg));
            this.stringRedisTemplate.convertAndSend(RedisKeyConstants.SOCKET_MSG_TOPIC, (Object)JSON.toJSONString((Object)p2cBaseMsg));
        }
        catch (Exception e) {
            log.error("[\u96c6\u7fa4\u4e0b\u5e7f\u64ad\u5931\u8d25]|\u8bbe\u5907[{}]|\u6d88\u606f[{}]", new Object[]{p2cBaseMsg.getSn(), JSON.toJSONString((Object)p2cBaseMsg), e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
        return ObjectResponse.success((Object)true);
    }

    public ObjectResponse<Boolean> sendSocketMsg(WebSocketMessage message) {
        try {
            String content = JSON.toJSONString((Object)message);
            log.info("\u6d88\u606f\u53d1\u653e\u5185\u5bb9,{}", (Object)content);
            this.stringRedisTemplate.convertAndSend(RedisKeyConstants.SOCKET_MSG_TOPIC, (Object)content);
        }
        catch (Exception e) {
            log.error("\u96c6\u7fa4\u4e0b\u5e7f\u64ad\u5931\u8d25|{}|{}", new Object[]{message.getModule(), message.getChannel(), e});
            return ObjectResponse.failed((CodeConstantsEnum)CodeConstantsEnum.ERROR);
        }
        return ObjectResponse.success((Object)true);
    }
}

