/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.redis.config;

import com.icetech.redis.handle.IceProxyMsgHandle;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;

@Configuration
public class SocketAloneRedisInject
implements EnvironmentAware {
    private static final String ALONE_PREFIX = "ice-socket.alone-redis";
    @Autowired(required=false)
    private IceProxyMsgHandle iceProxyMsgHandle;

    public void setEnvironment(Environment environment) {
        if (environment.getProperty("ice-socket.alone-redis.host") == null) {
            return;
        }
        RedisProperties cfg = (RedisProperties)Binder.get((Environment)environment).bind(ALONE_PREFIX, RedisProperties.class).get();
        RedisStandaloneConfiguration redisConfig = new RedisStandaloneConfiguration();
        redisConfig.setHostName(cfg.getHost());
        redisConfig.setPort(cfg.getPort());
        redisConfig.setDatabase(cfg.getDatabase());
        redisConfig.setPassword(RedisPassword.of((String)cfg.getPassword()));
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        RedisProperties.Lettuce lettuce = cfg.getLettuce();
        if (lettuce.getPool() != null) {
            RedisProperties.Pool pool = cfg.getLettuce().getPool();
            poolConfig.setMaxTotal(pool.getMaxActive());
            poolConfig.setMaxIdle(pool.getMaxIdle());
            poolConfig.setMinIdle(pool.getMinIdle());
            poolConfig.setMaxWaitMillis(pool.getMaxWait().toMillis());
        }
        LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder builder = LettucePoolingClientConfiguration.builder();
        if (cfg.getTimeout() != null) {
            builder.commandTimeout(cfg.getTimeout());
        }
        if (lettuce.getShutdownTimeout() != null) {
            builder.shutdownTimeout(lettuce.getShutdownTimeout());
        }
        LettucePoolingClientConfiguration clientConfig = builder.poolConfig(poolConfig).build();
        LettuceConnectionFactory factory = new LettuceConnectionFactory(redisConfig, (LettuceClientConfiguration)clientConfig);
        factory.afterPropertiesSet();
        this.iceProxyMsgHandle.init((RedisConnectionFactory)factory);
    }
}

