/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.redis.config;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class CustomStringRedisSerializer
implements RedisSerializer<String> {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Pattern PATTERN = Pattern.compile("^\\[\"(\\w+\\.)+\\w+\",");
    private Jackson2JsonRedisSerializer<Object> jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);

    public byte[] serialize(String value) throws SerializationException {
        if (value == null) {
            return new byte[0];
        }
        return value.getBytes(DEFAULT_CHARSET);
    }

    public String deserialize(byte[] bytes) throws SerializationException {
        if (ArrayUtils.isEmpty((byte[])bytes)) {
            return null;
        }
        String cache = new String(bytes, DEFAULT_CHARSET);
        if (PATTERN.matcher(cache).find()) {
            Object object = this.jackson2JsonRedisSerializer.deserialize(bytes);
            if (object == null) {
                return null;
            }
            return JSON.toJSONString((Object)object);
        }
        return cache;
    }

    public CustomStringRedisSerializer() {
        final ObjectMapper om = new ObjectMapper();
        om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        om.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        om.addHandler(new DeserializationProblemHandler(){

            public JavaType handleUnknownTypeId(DeserializationContext ctxt, JavaType baseType, String subTypeId, TypeIdResolver idResolver, String failureMsg) throws IOException {
                return om.getTypeFactory().constructRawMapType(LinkedHashMap.class);
            }

            public JavaType handleMissingTypeId(DeserializationContext ctxt, JavaType baseType, TypeIdResolver idResolver, String failureMsg) throws IOException {
                return om.getTypeFactory().constructRawMapType(LinkedHashMap.class);
            }
        });
        this.jackson2JsonRedisSerializer.setObjectMapper(om);
    }
}

