/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.mq.sender;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.icetech.common.utils.Slf4jUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.common.utils.UUIDTools;
import com.icetech.mq.CorrelationData;
import com.icetech.mq.IMQExceptionData;
import com.icetech.mq.config.DelayBean;
import com.icetech.mq.config.RabbitMultipleAutoConfiguration;
import com.icetech.mq.constants.Constant;
import com.icetech.mq.listener.ErrorMsgBean;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.PropertyMapper;

public class RabbitSender {
    private static final Logger log = LoggerFactory.getLogger(RabbitSender.class);
    private RabbitTemplate rabbitTemplate;
    @Autowired(required=false)
    private IMQExceptionData iMQExceptionData;
    private RabbitMultipleAutoConfiguration rabbitMultipleAutoConfiguration;
    @Value(value="${spring.rabbitmq.mqName:}")
    private String mqName;

    public RabbitSender() {
    }

    public RabbitSender(RabbitTemplate rabbitTemplate, ObjectProvider<RabbitMultipleAutoConfiguration> rabbitMultipleAutoConfiguration) {
        this.rabbitTemplate = rabbitTemplate;
        PropertyMapper map = PropertyMapper.get();
        map.from(() -> rabbitMultipleAutoConfiguration.getIfUnique()).whenNonNull().to(this::setRabbitMultipleAutoConfiguration);
        this.setCallback(this.mqName, rabbitTemplate);
        if (this.rabbitMultipleAutoConfiguration == null || MapUtils.isEmpty(this.rabbitMultipleAutoConfiguration.getRabbitTemplateMap())) {
            return;
        }
        Map<String, RabbitTemplate> rabbitTemplateMap = this.rabbitMultipleAutoConfiguration.getRabbitTemplateMap();
        if (MapUtils.isNotEmpty(rabbitTemplateMap)) {
            rabbitTemplateMap.forEach(this::setCallback);
        }
    }

    private void setRabbitMultipleAutoConfiguration(RabbitMultipleAutoConfiguration rabbitMultipleAutoConfiguration) {
        this.rabbitMultipleAutoConfiguration = rabbitMultipleAutoConfiguration;
    }

    private void setCallback(String mqName, RabbitTemplate rabbitTemplate) {
        ConnectionFactory connectionFactory = this.getPublisherConnectionFactory(rabbitTemplate);
        if (connectionFactory.isPublisherConfirms()) {
            rabbitTemplate.setConfirmCallback((correlationData, ack, cause) -> {
                if (!ack) {
                    this.confirm(mqName, rabbitTemplate, correlationData, false, cause);
                    log.info("sender not send message to the right exchange correlationData={} ack={} cause{}", new Object[]{correlationData, false, cause});
                } else {
                    log.debug("sender send message to the right exchange correlationData={} ack={} cause{}", new Object[]{correlationData, true, cause});
                }
            });
        }
        if (connectionFactory.isPublisherReturns()) {
            rabbitTemplate.setReturnCallback((message, replyCode, replyText, tmpExchange, tmpRoutingKey) -> {
                if ("common.msg.error.queue".equals(tmpRoutingKey)) {
                    return;
                }
                this.returnedMessage(message, replyCode, replyText, tmpExchange, tmpRoutingKey);
            });
        }
    }

    public void sendMessage(String exchangeName, String routingKey, Object msg) {
        this.sendMsg(null, exchangeName, routingKey, msg, 0L);
    }

    public void sendMessage(String exchangeName, String routingKey, Object msg, Long delay) {
        this.sendMsg(null, exchangeName, routingKey, msg, delay);
    }

    public void sendMessage(String exchangeName, String routingKey, Object msg, Long delay, Collection<String> mqNames) {
        if (CollectionUtils.isEmpty(mqNames)) {
            return;
        }
        mqNames.forEach(mqName -> {
            try {
                this.sendMsg((String)mqName, exchangeName, routingKey, msg, delay);
            }
            catch (Exception e) {
                log.error("mq \u4fe1\u606f\u914d\u7f6e\u5f02\u5e38,mqName:{}", mqName, (Object)e);
            }
        });
    }

    public void sendMessageAllMq(String exchangeName, String routingKey, Object msg, Long delay) {
        if (this.rabbitMultipleAutoConfiguration == null || MapUtils.isEmpty(this.rabbitMultipleAutoConfiguration.getRabbitTemplateMap())) {
            log.error("\u591a mq \u4fe1\u606f\u672a\u914d\u7f6e");
            return;
        }
        Map<String, RabbitTemplate> rabbitTemplateMap = this.rabbitMultipleAutoConfiguration.getRabbitTemplateMap();
        if (MapUtils.isNotEmpty(rabbitTemplateMap)) {
            rabbitTemplateMap.forEach((k, v) -> {
                try {
                    if (!Constant.commonMq.equals(k)) {
                        this.sendMsg((String)k, exchangeName, routingKey, msg, delay);
                    }
                }
                catch (Exception e) {
                    log.error("mq \u4fe1\u606f\u914d\u7f6e\u5f02\u5e38,mqName:{}", k, (Object)e);
                }
            });
        }
    }

    public void sendMessage(String exchangeName, String routingKey, Object msg, Long delay, DelayBean delayBean, Collection<String> mqNames) {
        log.info("\u5ef6\u8fdf\u6d88\u606f\u4e2d\u95f4\u961f\u5217\u53d1\u9001\u6d88\u606f\uff0c{}", JSON.toJSON((Object)delayBean));
        if (CollectionUtils.isNotEmpty(mqNames)) {
            for (String mqName : mqNames) {
                try {
                    this.sendMsg(mqName, exchangeName, routingKey, msg, delay);
                }
                catch (Exception e) {
                    log.error("mq \u4fe1\u606f\u83b7\u53d6\u5f02\u5e38, mqName:{}", (Object)mqName, (Object)e);
                }
            }
            return;
        }
        this.sendMsg(null, exchangeName, routingKey, msg, delay);
    }

    private void sendMsg(String mqName, String exchangeName, String routingKey, Object msg, Long delay) {
        RabbitTemplate rabbitTemplate;
        if (StringUtils.isEmpty((CharSequence)mqName)) {
            rabbitTemplate = this.rabbitTemplate;
        } else {
            try {
                rabbitTemplate = this.getRabbitTemplate(mqName);
            }
            catch (Exception e) {
                rabbitTemplate = this.rabbitTemplate;
            }
        }
        CorrelationData correlationData = this.correlationData(msg, exchangeName, routingKey);
        log.info("\u53d1\u9001MQ\u6d88\u606f\uff0c\u6d88\u606fID\uff1a{}\uff0c\u6d88\u606f\u4f53:{}, exchangeName:{}, routingKey:{}, delay{}", new Object[]{correlationData.getId(), JSON.toJSONString((Object)msg), exchangeName, routingKey, delay});
        if (delay != null && delay > Integer.MAX_VALUE) {
            DelayBean delayBean = new DelayBean(correlationData.getId(), mqName, exchangeName, routingKey, delay, msg);
            this.sendMessage("common.delay", "common.middle", delayBean, (Long)Integer.MAX_VALUE, Lists.newArrayList((Object[])new String[]{Constant.commonMq}));
            return;
        }
        this.convertAndSend(rabbitTemplate, exchangeName, routingKey, msg, correlationData, delay, null);
        if (delay != null && delay > 0L) {
            DelayBean delayBean = new DelayBean(correlationData.getId(), StringUtils.isEmpty((CharSequence)mqName) ? this.mqName : mqName, exchangeName, routingKey, delay, msg);
            this.sendMsg(Constant.commonMq, "", "common.delay.msg.queue", delayBean, 0L);
        }
    }

    public void confirm(String mqName, RabbitTemplate rabbitTemplate, org.springframework.amqp.rabbit.connection.CorrelationData correlationData, boolean ack, String cause) {
        if (!ack && correlationData instanceof CorrelationData) {
            CorrelationData correlationDataExtends = (CorrelationData)correlationData;
            int maxRetryCount = 0;
            if (correlationDataExtends.getRetryCount() < maxRetryCount) {
                log.info("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u6d88\u606f\u91cd\u53d1\uff0c\u6d88\u606fID\uff1a{}\uff0c\u91cd\u53d1\u6b21\u6570\uff1a{}\uff0c\u6d88\u606f\u4f53:{}, cause:{}", new Object[]{correlationDataExtends.getId(), correlationDataExtends.getRetryCount(), JSON.toJSONString((Object)correlationDataExtends.getMessage()), cause});
                correlationDataExtends.setRetryCount(correlationDataExtends.getRetryCount() + 1);
                this.convertAndSend(rabbitTemplate, correlationDataExtends.getExchange(), correlationDataExtends.getRoutingKey(), correlationDataExtends.getMessage(), correlationDataExtends, 0L, correlationDataExtends.getMessage().getClass().getName());
            } else {
                log.error("MQ\u6d88\u606f\u91cd\u53d1\u5931\u8d25\uff0c\u6d88\u606f\u5165\u5e93\uff0c\u6d88\u606fID\uff1a{}\uff0c\u6d88\u606f\u4f53:{}, cause:{}", new Object[]{correlationData.getId(), JSON.toJSONString((Object)correlationDataExtends.getMessage()), cause});
                if (this.iMQExceptionData != null) {
                    this.iMQExceptionData.sendException(correlationDataExtends.getExchange(), correlationDataExtends.getRoutingKey(), correlationDataExtends.getMessage());
                } else {
                    ErrorMsgBean errorMsgBean = new ErrorMsgBean(correlationDataExtends.getId(), mqName, correlationDataExtends.getExchange(), correlationDataExtends.getRoutingKey(), correlationDataExtends.getMessage(), correlationDataExtends.getMessage().getClass().getName(), 1, 1, cause);
                    this.sendMessage("", "common.msg.error.queue", errorMsgBean, 0L, Lists.newArrayList((Object[])new String[]{Constant.commonMq}));
                }
            }
        } else {
            log.info("\u6d88\u606f\u53d1\u9001\u6210\u529f,\u6d88\u606fID:{}", (Object)correlationData.getId());
        }
    }

    public void returnedMessage(Message message, int replyCode, String replyText, String exchange, String routingKey) {
        if (StringUtils.getInt((Object)message.getMessageProperties().getReceivedDelay()) > 0 || "common.msg.error.queue".equals(routingKey)) {
            return;
        }
        log.error("MQ\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0creplyCode:{}, replyText:{}\uff0cexchange:{}\uff0croutingKey:{}\uff0c\u6d88\u606f\u4f53:{}", new Object[]{replyCode, replyText, exchange, routingKey, new String(message.getBody())});
        if (this.iMQExceptionData != null) {
            this.iMQExceptionData.sendException(exchange, routingKey, message);
        } else {
            String className = (String)message.getMessageProperties().getHeaders().get(Constant.className);
            ErrorMsgBean errorMsgBean = new ErrorMsgBean(message.getMessageProperties().getCorrelationId(), this.mqName, exchange, exchange, new String(message.getBody()), className, 1, 2, replyText);
            this.sendMessage("", "common.msg.error.queue", errorMsgBean, 0L, Lists.newArrayList((Object[])new String[]{Constant.commonMq}));
        }
    }

    private CorrelationData correlationData(Object message, String exchange, String routingKey) {
        return new CorrelationData(UUIDTools.getUuid(), message, exchange, routingKey);
    }

    private void convertAndSend(RabbitTemplate rabbitTemplate, String exchange, String routingKey, Object msg, CorrelationData correlationData, Long delay, String className) throws AmqpException {
        try {
            rabbitTemplate.convertAndSend(exchange, routingKey, msg, message -> {
                if (delay != null && delay > 0L) {
                    message.getMessageProperties().setDelay(Integer.valueOf(delay.intValue()));
                }
                if (className != null) {
                    message.getMessageProperties().setHeader(Constant.className, (Object)className);
                }
                message.getMessageProperties().setMessageId(correlationData.getId());
                message.getMessageProperties().setCorrelationId(Slf4jUtils.putTraceIdIfAbsent());
                return message;
            }, (org.springframework.amqp.rabbit.connection.CorrelationData)correlationData);
        }
        catch (Exception e) {
            log.error("MQ\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff0c\u6d88\u606fID\uff1a{}\uff0c\u6d88\u606f\u4f53:{}, exchangeName:{}, routingKey:{}", new Object[]{correlationData.getId(), JSON.toJSONString((Object)msg), exchange, routingKey, e});
        }
    }

    public Message convertMessage(Object msg) {
        return this.rabbitTemplate.getMessageConverter().toMessage(msg, new MessageProperties());
    }

    private ConnectionFactory getPublisherConnectionFactory(RabbitTemplate rabbitTemplate) {
        return rabbitTemplate.isUsePublisherConnection() && rabbitTemplate.getConnectionFactory().getPublisherConnectionFactory() != null ? rabbitTemplate.getConnectionFactory().getPublisherConnectionFactory() : rabbitTemplate.getConnectionFactory();
    }

    private RabbitTemplate getRabbitTemplate(String mqName) throws Exception {
        if (this.rabbitMultipleAutoConfiguration != null && this.rabbitMultipleAutoConfiguration.getRabbitTemplateMap().containsKey(mqName)) {
            return this.rabbitMultipleAutoConfiguration.getRabbitTemplate(mqName);
        }
        throw new Exception("mq \u4fe1\u606f \u672a\u914d\u7f6e");
    }

    public void setRabbitTemplate(RabbitTemplate rabbitTemplate) {
        this.rabbitTemplate = rabbitTemplate;
    }
}

