/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.mq.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.icetech.common.constants.CommonConstants;
import com.icetech.common.utils.StringUtils;
import com.icetech.mq.IMQExceptionData;
import com.icetech.mq.constants.Constant;
import com.icetech.mq.listener.ErrorMsgBean;
import com.icetech.mq.sender.RabbitSender;
import com.rabbitmq.client.Channel;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ResolvableType;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.util.Assert;

public abstract class MessageListenerAbstract<T> {
    private static final Logger log = LoggerFactory.getLogger(MessageListenerAbstract.class);
    protected int tryCount = 0;
    protected IMQExceptionData iMQExceptionData;
    @Autowired
    private RabbitSender rabbitSender;
    @Value(value="${spring.rabbitmq.mqName:}")
    private String mqName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RabbitHandler(isDefault=true)
    public void onMessage(@Payload T msg, Channel channel, Message message) throws Exception {
        MDC.put((String)CommonConstants.TRACE_ID_KEY, (String)message.getMessageProperties().getCorrelationId());
        String consumerQueue = message.getMessageProperties().getConsumerQueue();
        try {
            Assert.notNull(msg, (String)"sendMessage \u6d88\u606f\u4f53\u4e0d\u80fd\u4e3aNULL");
            this.process(msg);
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
        }
        catch (Throwable e) {
            block12: {
                int count = StringUtils.getInt(message.getMessageProperties().getHeaders().get(Constant.tryCountKey));
                log.error("MQ\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff0c\u6d88\u606f\u4f53:{}, \u6d88\u606f\u5185\u5bb9:{}\uff0c \u5931\u8d25\u7b2c {} \u6b21 ", new Object[]{message.getMessageProperties().getCorrelationId(), JSON.toJSONString(msg), count + 1, e});
                if (count >= this.tryCount) break block12;
                message.getMessageProperties().getHeaders().put(Constant.tryCountKey, ++count);
                channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
                this.rabbitSender.sendMessage("", consumerQueue, message);
                return;
            }
            try {
                String className = (String)message.getMessageProperties().getHeaders().get(Constant.className);
                ErrorMsgBean errorMsgBean = new ErrorMsgBean(message.getMessageProperties().getCorrelationId(), this.mqName, consumerQueue, msg, !StringUtils.isEmpty((CharSequence)className) ? className : msg.getClass().getName(), 2, e.getMessage());
                if (this.iMQExceptionData != null) {
                    this.iMQExceptionData.processException(consumerQueue, JSON.toJSONString((Object)errorMsgBean));
                } else {
                    this.rabbitSender.sendMessage("", "common.msg.error.queue", errorMsgBean, 0L, Lists.newArrayList((Object[])new String[]{Constant.commonMq}));
                }
                channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
            }
            catch (Throwable dbe) {
                log.error("\u4fdd\u5b58\u5f02\u5e38MQ\u6d88\u606f\u5230\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u653e\u5230\u6b7b\u6027\u961f\u5217\uff0c\u6d88\u606f\u4f53\uff1a{}", (Object)JSON.toJSONString(msg), (Object)dbe);
                channel.basicNack(message.getMessageProperties().getDeliveryTag(), false, false);
            }
        }
        finally {
            MDC.remove((String)CommonConstants.TRACE_ID_KEY);
        }
    }

    @RabbitHandler
    public void onMessageMsg(@Payload Object msg, Channel channel, Message message) throws Exception {
        Object t;
        try {
            Class<?> clazz = this.getClass();
            while (true) {
                if (clazz.getSuperclass().getName().equals(MessageListenerAbstract.class.getName())) break;
                clazz = clazz.getSuperclass();
            }
            ResolvableType resolvableType = ResolvableType.forClass(clazz);
            Class resolve = resolvableType.getSuperType().getGeneric(new int[]{0}).resolve();
            t = resolve.getName().equals(msg.getClass().getName()) ? msg : (msg instanceof String ? JSON.parseObject((String)((String)msg), (Type)resolve, (Feature[])new Feature[0]) : JSON.parseObject((String)JSON.toJSONString((Object)msg), (Type)resolve, (Feature[])new Feature[0]));
        }
        catch (Exception e) {
            log.error("JSON \u89e3\u6790\u5f02\u5e38,{}", JSON.toJSON((Object)msg), (Object)e);
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
            return;
        }
        this.onMessage(t, channel, message);
    }

    protected abstract void process(T var1);
}

