/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.mq.config;

import com.google.common.collect.Maps;
import com.icetech.mq.config.RabbitMultipleProperties;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitRetryTemplateCustomizer;
import org.springframework.boot.autoconfigure.amqp.RabbitTemplateConfigurer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={RabbitMultipleProperties.class})
public class RabbitMultipleAutoConfiguration
extends RabbitAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RabbitMultipleAutoConfiguration.class);
    private final Map<String, RabbitTemplate> rabbitTemplateMap = Maps.newConcurrentMap();

    public RabbitMultipleAutoConfiguration(RabbitMultipleProperties rabbitMultipleProperties, ObjectProvider<ConnectionNameStrategy> connectionNameStrategy, ObjectProvider<MessageConverter> messageConverter, ObjectProvider<RabbitRetryTemplateCustomizer> retryTemplateCustomizers) throws Exception {
        List<RabbitMultipleProperties.RabbitPropertiesExtend> mqs = rabbitMultipleProperties.getMqs();
        if (CollectionUtils.isEmpty(mqs)) {
            return;
        }
        for (RabbitMultipleProperties.RabbitPropertiesExtend rabbitProperties : mqs) {
            if (StringUtils.isEmpty((Object)rabbitProperties.getMqName())) {
                log.error("mq name is null");
                throw new Exception("mq name is null");
            }
            try {
                RabbitConnectionFactoryCreatorChildren rabbitConnectionFactoryCreatorChildren = new RabbitConnectionFactoryCreatorChildren();
                CachingConnectionFactory cachingConnectionFactory = rabbitConnectionFactoryCreatorChildren.rabbitConnectionFactory(rabbitProperties, connectionNameStrategy);
                RabbitTemplateConfigurationChildren rabbitTemplateConfiguration = new RabbitTemplateConfigurationChildren();
                RabbitTemplateConfigurer rabbitTemplateConfigurer = rabbitTemplateConfiguration.rabbitTemplateConfigurer(rabbitProperties, messageConverter, retryTemplateCustomizers);
                RabbitTemplate rabbitTemplate = rabbitTemplateConfiguration.rabbitTemplate(rabbitTemplateConfigurer, (ConnectionFactory)cachingConnectionFactory);
                rabbitTemplate.setUsePublisherConnection(rabbitProperties.isUsePublisherConnection());
                this.rabbitTemplateMap.put(rabbitProperties.getMqName(), rabbitTemplate);
            }
            catch (Exception e) {
                log.error("multiple mq config exception", (Throwable)e);
                throw new Exception("multiple mq config exception");
            }
        }
    }

    public RabbitTemplate getRabbitTemplate(String mqName) throws Exception {
        RabbitTemplate rabbitTemplate = this.rabbitTemplateMap.get(mqName);
        if (rabbitTemplate == null) {
            throw new Exception("mq \u4fe1\u606f \u672a\u914d\u7f6e");
        }
        return rabbitTemplate;
    }

    public Map<String, RabbitTemplate> getRabbitTemplateMap() {
        return this.rabbitTemplateMap;
    }

    private static class RabbitTemplateConfigurationChildren
    extends RabbitAutoConfiguration.RabbitTemplateConfiguration {
        private RabbitTemplateConfigurationChildren() {
        }
    }

    private static class RabbitConnectionFactoryCreatorChildren
    extends RabbitAutoConfiguration.RabbitConnectionFactoryCreator {
        private RabbitConnectionFactoryCreatorChildren() {
        }
    }
}

