/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.mq.config;

import com.alibaba.fastjson.JSON;
import com.icetech.common.utils.FileUtil;
import com.icetech.mq.config.RabbitBean;
import com.icetech.mq.config.RabbitDeclareProperties;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class IceRabbitDeclareBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(IceRabbitDeclareBeanPostProcessor.class);
    private ApplicationContext applicationContext;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        if (!Object.class.equals((Object)targetClass) && targetClass.isAssignableFrom(RabbitDeclareProperties.class)) {
            this.declare((RabbitDeclareProperties)bean);
        }
        return bean;
    }

    protected void declare(RabbitDeclareProperties properties) {
        this.readJson(properties);
        RabbitAdmin rabbitAdmin = (RabbitAdmin)this.applicationContext.getBean(RabbitAdmin.class);
        properties.getExchange().entrySet().stream().map(entry -> {
            RabbitDeclareProperties.ExchangeInfo info = (RabbitDeclareProperties.ExchangeInfo)entry.getValue();
            if (StringUtils.isBlank((CharSequence)info.getName())) {
                info.setName((String)entry.getKey());
            }
            return info;
        }).filter(RabbitDeclareProperties.ExchangeInfo::isDeclare).map(RabbitDeclareProperties.ExchangeInfo::buildExchange).forEach(exchange -> {
            rabbitAdmin.declareExchange(exchange);
            log.info("RabbitMQ \u4ea4\u6362\u673a\u521b\u5efa\u6210\u529f|{}", (Object)exchange.getName());
        });
        properties.getQueue().entrySet().stream().map(entry -> {
            RabbitDeclareProperties.QueueInfo info = (RabbitDeclareProperties.QueueInfo)entry.getValue();
            if (StringUtils.isBlank((CharSequence)info.getName())) {
                info.setName((String)entry.getKey());
            }
            return info;
        }).filter(RabbitDeclareProperties.QueueInfo::isDeclare).map(RabbitDeclareProperties.QueueInfo::buildQueue).forEach(queue -> {
            rabbitAdmin.declareQueue(queue);
            log.info("RabbitMQ \u961f\u5217\u521b\u5efa\u6210\u529f|{}", (Object)queue.getName());
        });
        properties.getBinding().values().stream().filter(RabbitDeclareProperties.BindingInfo::isDeclare).map(RabbitDeclareProperties.BindingInfo::buildBinding).forEach(binding -> {
            rabbitAdmin.declareBinding(binding);
            log.info("RabbitMQ \u961f\u5217\u7ed1\u5b9a\u4ea4\u6362\u673a\u6210\u529f|{}|{}|{}", new Object[]{binding.getDestination(), binding.getExchange(), binding.getRoutingKey()});
        });
    }

    private void readJson(RabbitDeclareProperties properties) {
        String configPath = this.applicationContext.getEnvironment().getProperty("spring.rabbitmq.configPath", "config/mqcs.json");
        List rabbitBeans = Optional.of(configPath).filter(StringUtils::isNotBlank).map(path -> {
            try {
                return FileUtil.getReadFile((String)path);
            }
            catch (IOException e) {
                throw new RuntimeException("mq \u914d\u7f6e\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u7684json \u6570\u636e", e);
            }
        }).map(json -> JSON.parseArray((String)json, RabbitBean.class)).orElse(Collections.emptyList());
        for (RabbitBean rabbitBean : rabbitBeans) {
            properties.getQueue().computeIfAbsent(rabbitBean.getQueue(), key -> {
                RabbitDeclareProperties.QueueInfo info = new RabbitDeclareProperties.QueueInfo().setName(rabbitBean.getQueue()).setDurable(rabbitBean.isDurable()).setExclusive(rabbitBean.isExclusive()).setAutoDelete(rabbitBean.isAutoDelete()).setTtl(rabbitBean.getTtl());
                if (rabbitBean.isDeadQueue()) {
                    info.setDeadLetterExchange("dead-" + rabbitBean.getExchange()).setDeadLetterRoutingKey(rabbitBean.getRouting());
                }
                return info;
            });
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{rabbitBean.getExchange(), rabbitBean.getRouting()})) continue;
            properties.getExchange().computeIfAbsent(rabbitBean.getExchange(), key -> new RabbitDeclareProperties.ExchangeInfo().setName(rabbitBean.getExchange()).setDelayed(rabbitBean.isDelayed()));
            String bindingKey = rabbitBean.getExchange() + "&" + rabbitBean.getQueue() + "&" + rabbitBean.getRouting();
            properties.getBinding().computeIfAbsent(bindingKey, key -> new RabbitDeclareProperties.BindingInfo().setExchange(rabbitBean.getExchange()).setDestination(rabbitBean.getQueue()).setRoutingKey(rabbitBean.getRouting()));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

