package com.icetech.mq.listener;

import lombok.Data;

import java.io.Serializable;

/**
 * Description: 消费异常bean
 * @author wanggy 
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved.
 *
 * @version 1.0 2021年4月28日 8:03
 */
@Data
public class ErrorMsgBean implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 消息id
     */
    private String correlationId;

    /**
     * mq 名字
     */
    private String mqName;

    /**
     * 交换机
     */
    private String exchange;

    /**
     * 路由
     */
    private String routing;

    /**
     * 消费队列
     */
    private String consumerQueue;

    /**
     * 消息体
     */
    private Object msg;

    /**
     * 消息类名
     */
    private String className;

    /**
     * 异常信息
     */
    private String errMsg;

    /**
     *  类型， 1： 发送异常，2：消费异常
     */
    private int type;

    /**
     * 发送异常类型， 1： ask exception, 2: returned exception
     */
    private int sendType;

    public String getCorrelationId() {
        return correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getMqName() {
        return mqName;
    }

    public void setMqName(String mqName) {
        this.mqName = mqName;
    }

    public String getConsumerQueue() {
        return consumerQueue;
    }

    public void setConsumerQueue(String consumerQueue) {
        this.consumerQueue = consumerQueue;
    }

    public Object getMsg() {
        return msg;
    }

    public void setMsg(Object msg) {
        this.msg = msg;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String getExchange() {
        return exchange;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public String getRouting() {
        return routing;
    }

    public void setRouting(String routing) {
        this.routing = routing;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getSendType() {
        return sendType;
    }

    public void setSendType(int sendType) {
        this.sendType = sendType;
    }

    public ErrorMsgBean() {

    }

    /**
     * 消费异常使用
     * @param correlationId
     * @param mqName
     * @param consumerQueue
     * @param msg
     * @param className
     * @param errMsg
     */
    public ErrorMsgBean(String correlationId, String mqName, String consumerQueue, Object msg, String className, int type, String errMsg) {
        this.correlationId = correlationId;
        this.mqName = mqName;
        this.consumerQueue = consumerQueue;
        this.msg = msg;
        this.className = className;
        this.type = type;
        this.errMsg = errMsg;
    }

    /**
     * 发送使用
     * @param correlationId
     * @param mqName
     * @param exchange
     * @param routing
     * @param msg
     * @param type
     * @param sendType
     * @param errMsg
     */
    public ErrorMsgBean(String correlationId, String mqName, String exchange, String routing, Object msg, String className, int type, int sendType, String errMsg) {
        this.correlationId = correlationId;
        this.mqName = mqName;
        this.exchange = exchange;
        this.routing = routing;
        this.msg = msg;
        this.className = className;
        this.type = type;
        this.sendType = sendType;
        this.errMsg = errMsg;
    }
}
