package com.icetech.mq;

/**
 * @author wanggy
 * @date 2021/4/29 20:47
 */
public interface IMQExceptionData {

    /**
     * Description: 发送异常信息
     * Version1.0 2021-04-29 by wgy 创建
     *
     * @param exchangeName  交换机
     * @param routingKey    路由
     * @param message       消息
     */
    void sendException(String exchangeName, String routingKey, Object message);

    /**
     * Description: 处理一行信息
     * Version1.0 2021-04-29 by wgy 创建
     * @param consumerQueue 队列
     * @param msg           消息
     */
    void processException(String consumerQueue, String msg);
}
