/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.mq.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.core.AbstractExchange;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.QueueBuilder;

public class RabbitDeclareProperties {
    protected final Map<String, ExchangeInfo> exchange = new LinkedHashMap<String, ExchangeInfo>();
    protected final Map<String, QueueInfo> queue = new LinkedHashMap<String, QueueInfo>();
    protected final Map<String, BindingInfo> binding = new LinkedHashMap<String, BindingInfo>();

    public void setExchange(Map<String, ExchangeInfo> exchange) {
        if (MapUtils.isNotEmpty(exchange)) {
            this.exchange.putAll(exchange);
        }
    }

    public void setQueue(Map<String, QueueInfo> queue) {
        if (MapUtils.isNotEmpty(queue)) {
            this.queue.putAll(queue);
        }
    }

    public void setBinding(Map<String, BindingInfo> binding) {
        if (MapUtils.isNotEmpty(binding)) {
            this.binding.putAll(binding);
        }
    }

    public Map<String, ExchangeInfo> getExchange() {
        return this.exchange;
    }

    public Map<String, QueueInfo> getQueue() {
        return this.queue;
    }

    public Map<String, BindingInfo> getBinding() {
        return this.binding;
    }

    public String toString() {
        return "RabbitDeclareProperties(exchange=" + this.getExchange() + ", queue=" + this.getQueue() + ", binding=" + this.getBinding() + ")";
    }

    public static class BindingInfo {
        private boolean declare = true;
        private String admin;
        private String destination;
        private String exchange;
        private String routingKey;
        private Binding.DestinationType destinationType = Binding.DestinationType.QUEUE;
        private Map<String, Object> arguments;

        public Binding buildBinding() {
            return new Binding(this.destination, this.destinationType, this.exchange, this.routingKey, this.arguments);
        }

        public boolean isDeclare() {
            return this.declare;
        }

        public String getAdmin() {
            return this.admin;
        }

        public String getDestination() {
            return this.destination;
        }

        public String getExchange() {
            return this.exchange;
        }

        public String getRoutingKey() {
            return this.routingKey;
        }

        public Binding.DestinationType getDestinationType() {
            return this.destinationType;
        }

        public Map<String, Object> getArguments() {
            return this.arguments;
        }

        public BindingInfo setDeclare(boolean declare) {
            this.declare = declare;
            return this;
        }

        public BindingInfo setAdmin(String admin) {
            this.admin = admin;
            return this;
        }

        public BindingInfo setDestination(String destination) {
            this.destination = destination;
            return this;
        }

        public BindingInfo setExchange(String exchange) {
            this.exchange = exchange;
            return this;
        }

        public BindingInfo setRoutingKey(String routingKey) {
            this.routingKey = routingKey;
            return this;
        }

        public BindingInfo setDestinationType(Binding.DestinationType destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        public BindingInfo setArguments(Map<String, Object> arguments) {
            this.arguments = arguments;
            return this;
        }

        public String toString() {
            return "RabbitDeclareProperties.BindingInfo(declare=" + this.isDeclare() + ", admin=" + this.getAdmin() + ", destination=" + this.getDestination() + ", exchange=" + this.getExchange() + ", routingKey=" + this.getRoutingKey() + ", destinationType=" + this.getDestinationType() + ", arguments=" + this.getArguments() + ")";
        }
    }

    public static class QueueInfo {
        private boolean declare = true;
        private String admin;
        private String name;
        private boolean durable = true;
        private boolean exclusive = false;
        private boolean autoDelete = false;
        private int ttl = -1;
        private int expires = -1;
        private int maxLength = -1;
        private int maxLengthBytes = -1;
        private QueueBuilder.Overflow overflow;
        private String deadLetterExchange;
        private String deadLetterRoutingKey;
        private int maxPriority = -1;
        private boolean lazy = false;
        private QueueBuilder.MasterLocator masterLocator;
        private boolean singleActiveConsumer = false;
        private boolean quorum = false;
        private int deliveryLimit = -1;
        private Map<String, Object> arguments;

        public Queue buildQueue() {
            QueueBuilder builder;
            QueueBuilder queueBuilder = builder = this.durable ? QueueBuilder.durable((String)this.name) : QueueBuilder.nonDurable((String)this.name);
            if (this.exclusive) {
                builder.exclusive();
            }
            if (this.autoDelete) {
                builder.autoDelete();
            }
            if (this.ttl > 0) {
                builder.ttl(this.ttl);
            }
            if (this.expires > 0) {
                builder.expires(this.expires);
            }
            if (this.maxLength > 0) {
                builder.maxLength(this.maxLength);
            }
            if (this.maxLengthBytes > 0) {
                builder.maxLengthBytes(this.maxLengthBytes);
            }
            if (this.overflow != null) {
                builder.overflow(this.overflow);
            }
            if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.deadLetterExchange, this.deadLetterRoutingKey})) {
                builder.deadLetterExchange(this.deadLetterExchange).deadLetterRoutingKey(this.deadLetterRoutingKey);
            }
            if (this.maxPriority > 0) {
                builder.maxPriority(this.maxPriority);
            }
            if (this.lazy) {
                builder.lazy();
            }
            if (this.masterLocator != null) {
                builder.masterLocator(this.masterLocator);
            }
            if (this.singleActiveConsumer) {
                builder.singleActiveConsumer();
            }
            if (this.quorum) {
                builder.quorum();
            }
            if (this.deliveryLimit > 0) {
                builder.deliveryLimit(this.deliveryLimit);
            }
            if (MapUtils.isNotEmpty(this.arguments)) {
                builder.withArguments(this.arguments);
            }
            return builder.build();
        }

        public boolean isDeclare() {
            return this.declare;
        }

        public String getAdmin() {
            return this.admin;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDurable() {
            return this.durable;
        }

        public boolean isExclusive() {
            return this.exclusive;
        }

        public boolean isAutoDelete() {
            return this.autoDelete;
        }

        public int getTtl() {
            return this.ttl;
        }

        public int getExpires() {
            return this.expires;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public int getMaxLengthBytes() {
            return this.maxLengthBytes;
        }

        public QueueBuilder.Overflow getOverflow() {
            return this.overflow;
        }

        public String getDeadLetterExchange() {
            return this.deadLetterExchange;
        }

        public String getDeadLetterRoutingKey() {
            return this.deadLetterRoutingKey;
        }

        public int getMaxPriority() {
            return this.maxPriority;
        }

        public boolean isLazy() {
            return this.lazy;
        }

        public QueueBuilder.MasterLocator getMasterLocator() {
            return this.masterLocator;
        }

        public boolean isSingleActiveConsumer() {
            return this.singleActiveConsumer;
        }

        public boolean isQuorum() {
            return this.quorum;
        }

        public int getDeliveryLimit() {
            return this.deliveryLimit;
        }

        public Map<String, Object> getArguments() {
            return this.arguments;
        }

        public QueueInfo setDeclare(boolean declare) {
            this.declare = declare;
            return this;
        }

        public QueueInfo setAdmin(String admin) {
            this.admin = admin;
            return this;
        }

        public QueueInfo setName(String name) {
            this.name = name;
            return this;
        }

        public QueueInfo setDurable(boolean durable) {
            this.durable = durable;
            return this;
        }

        public QueueInfo setExclusive(boolean exclusive) {
            this.exclusive = exclusive;
            return this;
        }

        public QueueInfo setAutoDelete(boolean autoDelete) {
            this.autoDelete = autoDelete;
            return this;
        }

        public QueueInfo setTtl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public QueueInfo setExpires(int expires) {
            this.expires = expires;
            return this;
        }

        public QueueInfo setMaxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public QueueInfo setMaxLengthBytes(int maxLengthBytes) {
            this.maxLengthBytes = maxLengthBytes;
            return this;
        }

        public QueueInfo setOverflow(QueueBuilder.Overflow overflow) {
            this.overflow = overflow;
            return this;
        }

        public QueueInfo setDeadLetterExchange(String deadLetterExchange) {
            this.deadLetterExchange = deadLetterExchange;
            return this;
        }

        public QueueInfo setDeadLetterRoutingKey(String deadLetterRoutingKey) {
            this.deadLetterRoutingKey = deadLetterRoutingKey;
            return this;
        }

        public QueueInfo setMaxPriority(int maxPriority) {
            this.maxPriority = maxPriority;
            return this;
        }

        public QueueInfo setLazy(boolean lazy) {
            this.lazy = lazy;
            return this;
        }

        public QueueInfo setMasterLocator(QueueBuilder.MasterLocator masterLocator) {
            this.masterLocator = masterLocator;
            return this;
        }

        public QueueInfo setSingleActiveConsumer(boolean singleActiveConsumer) {
            this.singleActiveConsumer = singleActiveConsumer;
            return this;
        }

        public QueueInfo setQuorum(boolean quorum) {
            this.quorum = quorum;
            return this;
        }

        public QueueInfo setDeliveryLimit(int deliveryLimit) {
            this.deliveryLimit = deliveryLimit;
            return this;
        }

        public QueueInfo setArguments(Map<String, Object> arguments) {
            this.arguments = arguments;
            return this;
        }

        public String toString() {
            return "RabbitDeclareProperties.QueueInfo(declare=" + this.isDeclare() + ", admin=" + this.getAdmin() + ", name=" + this.getName() + ", durable=" + this.isDurable() + ", exclusive=" + this.isExclusive() + ", autoDelete=" + this.isAutoDelete() + ", ttl=" + this.getTtl() + ", expires=" + this.getExpires() + ", maxLength=" + this.getMaxLength() + ", maxLengthBytes=" + this.getMaxLengthBytes() + ", overflow=" + this.getOverflow() + ", deadLetterExchange=" + this.getDeadLetterExchange() + ", deadLetterRoutingKey=" + this.getDeadLetterRoutingKey() + ", maxPriority=" + this.getMaxPriority() + ", lazy=" + this.isLazy() + ", masterLocator=" + this.getMasterLocator() + ", singleActiveConsumer=" + this.isSingleActiveConsumer() + ", quorum=" + this.isQuorum() + ", deliveryLimit=" + this.getDeliveryLimit() + ", arguments=" + this.getArguments() + ")";
        }
    }

    public static class ExchangeInfo {
        private boolean declare = true;
        private String admin;
        private String name;
        private String type = "direct";
        private boolean durable = true;
        private boolean autoDelete = false;
        private boolean internal = false;
        private boolean delayed = false;
        private String alternate;
        private Map<String, Object> arguments;

        public Exchange buildExchange() {
            ExchangeBuilder builder = new ExchangeBuilder(this.name, this.type).durable(this.durable);
            if (this.autoDelete) {
                builder.autoDelete();
            }
            if (StringUtils.isNotBlank((CharSequence)this.alternate)) {
                builder.alternate(this.alternate);
            }
            if (MapUtils.isNotEmpty(this.arguments)) {
                builder.withArguments(this.arguments);
            }
            AbstractExchange exchange = (AbstractExchange)builder.build();
            exchange.setInternal(this.internal);
            exchange.setDelayed(this.delayed);
            return exchange;
        }

        public boolean isDeclare() {
            return this.declare;
        }

        public String getAdmin() {
            return this.admin;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean isDurable() {
            return this.durable;
        }

        public boolean isAutoDelete() {
            return this.autoDelete;
        }

        public boolean isInternal() {
            return this.internal;
        }

        public boolean isDelayed() {
            return this.delayed;
        }

        public String getAlternate() {
            return this.alternate;
        }

        public Map<String, Object> getArguments() {
            return this.arguments;
        }

        public ExchangeInfo setDeclare(boolean declare) {
            this.declare = declare;
            return this;
        }

        public ExchangeInfo setAdmin(String admin) {
            this.admin = admin;
            return this;
        }

        public ExchangeInfo setName(String name) {
            this.name = name;
            return this;
        }

        public ExchangeInfo setType(String type) {
            this.type = type;
            return this;
        }

        public ExchangeInfo setDurable(boolean durable) {
            this.durable = durable;
            return this;
        }

        public ExchangeInfo setAutoDelete(boolean autoDelete) {
            this.autoDelete = autoDelete;
            return this;
        }

        public ExchangeInfo setInternal(boolean internal) {
            this.internal = internal;
            return this;
        }

        public ExchangeInfo setDelayed(boolean delayed) {
            this.delayed = delayed;
            return this;
        }

        public ExchangeInfo setAlternate(String alternate) {
            this.alternate = alternate;
            return this;
        }

        public ExchangeInfo setArguments(Map<String, Object> arguments) {
            this.arguments = arguments;
            return this;
        }

        public String toString() {
            return "RabbitDeclareProperties.ExchangeInfo(declare=" + this.isDeclare() + ", admin=" + this.getAdmin() + ", name=" + this.getName() + ", type=" + this.getType() + ", durable=" + this.isDurable() + ", autoDelete=" + this.isAutoDelete() + ", internal=" + this.isInternal() + ", delayed=" + this.isDelayed() + ", alternate=" + this.getAlternate() + ", arguments=" + this.getArguments() + ")";
        }
    }
}

