/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.mq.config;

import com.icetech.mq.config.IceRabbitDeclareBeanPostProcessor;
import com.icetech.mq.config.RabbitDeclareProperties;
import com.icetech.mq.config.RabbitMultipleAutoConfiguration;
import com.icetech.mq.sender.RabbitSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.amqp.SimpleRabbitListenerContainerFactoryConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ImportAutoConfiguration(value={IceRabbitDeclareBeanPostProcessor.class})
public class RabbitConfig {
    private static final Logger log = LoggerFactory.getLogger(RabbitConfig.class);

    @Bean
    public RabbitListenerContainerFactory<?> rabbitListenerContainerFactory(SimpleRabbitListenerContainerFactoryConfigurer configurer, ConnectionFactory connectionFactory, Jackson2JsonMessageConverter jsonMessageConverter) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        configurer.configure(factory, connectionFactory);
        factory.setMessageConverter((MessageConverter)jsonMessageConverter);
        return factory;
    }

    @Bean
    public RabbitAdmin rabbitAdmin(ConnectionFactory connectionFactory) {
        return new RabbitAdmin(connectionFactory);
    }

    @Bean
    @ConfigurationProperties(prefix="ice.rabbitmq.declare")
    public RabbitDeclareProperties rabbitDeclareProperties() {
        return new RabbitDeclareProperties();
    }

    @Bean
    @ConditionalOnMissingBean(value={RabbitSender.class})
    public RabbitSender rabbitSender(RabbitTemplate rabbitTemplate, ObjectProvider<RabbitMultipleAutoConfiguration> rabbitMultipleAutoConfiguration, @Value(value="${spring.rabbitmq.template.use-publisher-connection:true}") boolean usePublisherConnection) {
        rabbitTemplate.setUsePublisherConnection(usePublisherConnection);
        return new RabbitSender(rabbitTemplate, rabbitMultipleAutoConfiguration);
    }

    @Bean(name={"messageConverter"})
    @ConditionalOnMissingBean(value={MessageConverter.class})
    MessageConverter jackson2JsonMessageConverter() {
        return new Jackson2JsonMessageConverter();
    }
}

