package com.icetech.oss;

import java.io.File;
import java.io.InputStream;

public interface OssService {

    /**
     * 判断文件是否存在
     *
     * @param fileName
     * @return
     */
    boolean isExistFile(String fileName);

    /**
     * 判断文件是否存在
     *
     * @param fileName
     * @return
     */
    boolean isExistFile(String fileName, String bucketName);

    String buildImageUrl(String fileName);

    String buildImageUrl(String bucketName, String fileName);

    /**
     * 获取图片的链接
     *
     * @param name OSS文件路径/名称
     * @return
     */
    String getImageUrl(String name);

    /**
     * 获取图片的链接 时效性
     *
     * @param name      OSS文件路径/名称
     * @param expireSec 连接有效时间(单位秒, 为空或小于1则会变为默认过期时间 {@link OSSProperties#getDefaultExpireSeconds()})
     * @return OSS图片HTTP连接
     */
    String getImageUrlTime(String name, Long expireSec);

    String getImageUrl(String name, String bucketName);

    String getImageUrl(String bucketName, String name, Long expireSec);

    String getInternalImageUrl(String name);

    String getInternalImageUrl(String name, Long expireSec);

    String getInternalImageUrl(String name, String bucketName, Long expireSec);

    /**
     * 获取图片的流
     *
     * @param name
     * @return
     */
    InputStream getOSS2InputStream(String name);

    /**
     * 获取图片的流
     *
     * @param name
     * @param bucketName
     * @return
     */
    InputStream getOSS2InputStream(String name, String bucketName);

    /**
     * 下载文件 使用完成之后要及时删除
     *
     * @param fileName
     * @return
     */
    File getOSS2File(String fileName);

    /**
     * 下载文件 使用完成之后要及时删除
     *
     * @param fileName
     * @return
     */
    File getOSS2File(String fileName, String bucketName);

    boolean getOSS2File(String fileName, String bucketName, File file);

    /**
     * base64 上传
     *
     * @param base64
     * @param fileName
     */
    boolean uploadBase64(String base64, String fileName);

    /**
     * 根据bucket base 64 上传
     *
     * @param base64
     * @param fileName
     * @param bucketName
     */
    boolean uploadBase64(String base64, String fileName, String bucketName);

    /**
     * 字节上传文件
     *
     * @param fileStream
     * @param fileName
     */
    boolean uploadFileStream(byte[] fileStream, String fileName);

    /**
     * 字节上传文件
     *
     * @param fileStream
     * @param fileName
     * @param bucketName
     */
    boolean uploadFileStream(byte[] fileStream, String fileName, String bucketName);

    /**
     * 文件上传
     *
     * @param file
     * @param fileName
     */
    boolean uploadFile(File file, String fileName);

    /**
     * 文件上传
     *
     * @param file
     * @param fileName
     * @param bucketName
     */
    boolean uploadFile(File file, String fileName, String bucketName);

    /**
     * 上传文件
     *
     * @param inputStream
     * @param fileName
     */
    boolean uploadFile(InputStream inputStream, String fileName);

    /**
     * 上传文件
     *
     * @param inputStream
     * @param fileName
     * @param bucketName
     */
    boolean uploadFile(InputStream inputStream, String fileName, String bucketName);
}
