package com.icetech.oss.config;

import com.aliyun.oss.ClientBuilderConfiguration;
import com.icetech.oss.OSSProperties;
import com.icetech.oss.OssService;
import com.icetech.oss.impl.AliyunOssService;
import com.icetech.oss.impl.AmazonS3OssService;
import com.icetech.oss.impl.CtyunOssService;
import com.icetech.oss.impl.MinioOssService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(OSSProperties.class)
public class OSSAutoConfiguration {
    @Bean
    @ConfigurationProperties("oss.client.aliyun")
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix = "oss", name = "type", havingValue = OSSProperties.OSS_TYPE_ALIYUN, matchIfMissing = true)
    public ClientBuilderConfiguration clientBuilderConfiguration() {
        ClientBuilderConfiguration configuration = new ClientBuilderConfiguration();
//        configuration.setMaxConnections(1024);  // 允许打开的最大HTTP连接数。默认为1024
//        configuration.setSocketTimeout(50000);  // Socket层传输数据的超时时间（单位：毫秒）。默认为50000毫秒
//        configuration.setConnectionTimeout(50000);  // 建立连接的超时时间（单位：毫秒）。默认为50000毫秒
        configuration.setConnectionRequestTimeout(50000);   // 从连接池中获取连接的超时时间（单位：毫秒）。默认不超时
//        configuration.setIdleConnectionTime(60000); // 如果空闲时间超过此参数的设定值，则关闭连接（单位：毫秒）。默认为60000毫秒
//        configuration.setMaxErrorRetry(3);  // 请求失败后最大的重试次数。默认3次
//        configuration.setSupportCname(true);    // 是否支持CNAME作为Endpoint，默认支持CNAME
//        configuration.setSLDEnabled(false); // 是否开启二级域名（Second Level Domain）的访问方式，默认不开启
//        configuration.setProtocol(Protocol.HTTPS);  // 连接OSS所采用的协议（HTTP/HTTPS），默认为HTTP
//        configuration.setUserAgent("aliyun-sdk-java");  // 用户代理，指HTTP的User-Agent头。默认为"aliyun-sdk-java"
        return configuration;
    }

    @Bean
    @ConditionalOnProperty(prefix = "oss", name = "type", havingValue = OSSProperties.OSS_TYPE_ALIYUN, matchIfMissing = true)
    public OssService aliyunOssService(OSSProperties ossProperties, ClientBuilderConfiguration clientBuilderConfiguration) {
        return new AliyunOssService(ossProperties, clientBuilderConfiguration);
    }

    @Bean
    @ConditionalOnProperty(prefix = "oss", name = "type", havingValue = OSSProperties.OSS_TYPE_MINIO)
    public OssService minioOssService(OSSProperties ossProperties) {
        return new MinioOssService(ossProperties);
    }

    @Bean
    @ConditionalOnProperty(prefix = "oss", name = "type", havingValue = OSSProperties.OSS_TYPE_AMAZON_S3)
    public AmazonS3OssService amazonS3OssService(OSSProperties ossProperties) {
        return new AmazonS3OssService(ossProperties);
    }

    @Bean
    @ConditionalOnProperty(prefix = "oss", name = "type", havingValue = OSSProperties.OSS_TYPE_CTYUN)
    public OssService ctyunOssService(OSSProperties ossProperties) {
        return new CtyunOssService(ossProperties);
    }
}
