//package com.icetech.oss;
//
//import com.aliyun.oss.OSS;
//import com.aliyun.oss.model.GetObjectRequest;
//import com.aliyun.oss.model.OSSObject;
//import com.icetech.common.utils.Base64Tools;
//import lombok.Data;
//import lombok.extern.slf4j.Slf4j;
//import org.apache.commons.lang3.StringUtils;
//
//import java.io.ByteArrayInputStream;
//import java.io.File;
//import java.io.InputStream;
//import java.net.URL;
//import java.util.Date;
//
//@Slf4j
//@Data
//public class InternalOssService {
//
//    private OSS internalOss;
//    private OSSProperties ossProperties;
//
//    /**
//     * base64 上传
//     * @param base64
//     * @param fileName
//     */
//    public void uploadBase64(String base64, String fileName) {
//        try {
//            byte[] file = Base64Tools.decode2Byte(base64);
//            uploadFileStream(file, fileName);
//        }catch (Exception e){
//            log.error("[oss异常]e",e);
//        }
//
//    }
//
//    /**
//     * 根据bucket base 64 上传
//     * @param base64
//     * @param fileName
//     * @param bucketName
//     */
//    public void uploadBase64(String base64, String fileName,String bucketName) {
//        try {
//            byte[] file = Base64Tools.decode2Byte(base64);
//            uploadFileStream(file, fileName,bucketName);
//        }catch (Exception e){
//            log.error("[oss异常]e",e);
//        }
//    }
//
//    /**
//     * 获取图片的链接 时效性
//     * @param name
//     * @param s 链接的有效性 单位 秒
//     * @return
//     */
//    public String getImageUrlTime(String name,Long s){
//        try {
//            // 设置URL过期时间为1小时
//            Date expiration = new Date(System.currentTimeMillis() + s * 1000);
//            String bucketName = ossProperties.getBucketName();
//            // 生成URL
//            URL url = internalOss.generatePresignedUrl(bucketName, name,expiration);
//            String urlStr = url.toString().replace("http://","https://");
//            return urlStr;
//        }catch (Exception e){
//            log.error("[oss异常]e",e);
//        }
//        return null;
//    }
//
//    /**
//     * 获取图片的链接
//     * @param name
//     * @return
//     */
//    public String getImageUrl(String name){
//        try {
//            // 设置URL过期时间为1小时
//            Date expiration = new Date(System.currentTimeMillis() + 3600 * 1000);
//            String bucketName = ossProperties.getBucketName();
//            // 生成URL
//            URL url = internalOss.generatePresignedUrl(bucketName, name,expiration);
//            String urlStr = url.toString().replace("http://","https://");
//            return urlStr;
//        }catch (Exception e){
//            log.error("[oss异常]e",e);
//        }
//        return null;
//    }
//
//    public String getImageUrl(String name,String bucketName){
//        try {
//            String key = name;
//            // 设置URL过期时间为1小时
//            Date expiration = new Date(System.currentTimeMillis() + 3600 * 1000);
//            // 生成URL
//            URL url = internalOss.generatePresignedUrl(bucketName, key, expiration);
//            String urlStr = url.toString().replace("http://","https://");
//            return urlStr;
//        }catch (Exception e){
//            log.error("[oss异常]e",e);
//        }
//        return null;
//    }
//
//    /**
//     * 获取图片的流
//     * @param name
//     * @return
//     */
//    public InputStream getOSS2InputStream(String name){
//        try {
//            OSSObject ossObj = internalOss.getObject(ossProperties.getBucketName(), name);
//            InputStream stream = ossObj.getObjectContent();
//            return stream;
//        }catch (Exception e){
//            log.error("[oss异常]e",e);
//        }
//        return null;
//    }
//
//    /**
//     * 获取图片的流
//     * @param name
//     * @param bucketName
//     * @return
//     */
//    public InputStream getOSS2InputStream(String name,String bucketName){
//        try {
//            OSSObject ossObj = internalOss.getObject(bucketName, name);
//            InputStream stream = ossObj.getObjectContent();
//            return stream;
//        }catch (Exception e){
//            log.error("[oss异常]e",e);
//        }
//        return null;
//    }
//
//    /**
//     * 字节上传文件
//     * @param fileStream
//     * @param fileName
//     */
//    public void uploadFileStream(byte[] fileStream, String fileName){
//        try {
//            internalOss.putObject(ossProperties.getBucketName(), fileName, new ByteArrayInputStream(fileStream));
//        }catch (Exception e){
//            log.error("[oss异常]e",e);
//        }
//    }
//
//    /**
//     * 字节上传文件
//     * @param fileStream
//     * @param fileName
//     * @param bucketName
//     */
//    public void uploadFileStream(byte[] fileStream, String fileName,String bucketName){
//        try {
//            internalOss.putObject(bucketName, fileName, new ByteArrayInputStream(fileStream));
//        }catch (Exception e){
//            log.error("[oss异常]e",e);
//        }
//    }
//
//    /**
//     * 文件上传
//     * @param file
//     * @param fileName
//     */
//    public void uploadFile(File file, String fileName){
//        try {
//            internalOss.putObject(ossProperties.getBucketName(), fileName, file);
//        }catch (Exception e){
//            log.error("[oss异常]e",e);
//        }
//    }
//
//    /**
//     * 文件上传
//     * @param file
//     * @param fileName
//     * @param bucketName
//     */
//    public void uploadFile(File file, String fileName,String bucketName){
//        try {
//            internalOss.putObject(bucketName, fileName, file);
//        }catch (Exception e){
//            log.error("[oss异常]e",e);
//        }
//    }
//
//    /**
//     * 下载文件 使用完成之后要及时删除
//     * @param fileName
//     * @return
//     */
//    public File getOSS2File(String fileName){
//        try {
//            String bucketName = ossProperties.getBucketName();
//            String path = ossProperties.getDownPath();
//            if (StringUtils.isEmpty(path)){
//                path = "/tmp/oss/";
//            }
//            String[] split = fileName.split("/");
//            String fileName1 =split[split.length - 1];
//            log.info("***fileName="+fileName);
//            File file = new File(path);
//            if(!(file.exists()) && !(file.isDirectory())){
//                boolean mkdirs = file.mkdirs();
//                if(mkdirs){
//                    log.info("oss创建文件夹成功 路径:"+path);
//                }else {
//                    log.info("oss创建文件夹失败");
//                }
//            }
//            File file1 = new File(path + fileName1);
//            log.info("***File path: {}", file1);
//            internalOss.getObject(new GetObjectRequest(bucketName, fileName), file1);
//            return file1;
//        }catch (Exception e){
//            log.error("[oss异常]e",e);
//        }
//        return null;
//
//    }
//    /**
//     * 下载文件 使用完成之后要及时删除
//     * @param fileName
//     * @return
//     */
//    public File getOSS2File(String fileName,String bucketName){
//        try {
//            String path = ossProperties.getDownPath();
//            if (StringUtils.isEmpty(path)){
//                path = "/tmp/oss/";
//            }
//            String[] split = fileName.split("/");
//            String fileName1 =split[split.length - 1];
//            log.info("***fileName="+fileName);
//            File file = new File(path);
//            if(!(file.exists()) && !(file.isDirectory())){
//                boolean mkdirs = file.mkdirs();
//                if(mkdirs){
//                    log.info("创建文件夹成功 路径:"+path);
//                }else {
//                    log.info("创建文件夹失败");
//                }
//            }
//            File file1 = new File(path + fileName1);
//            log.info("***File path: {}", file1);
//            internalOss.getObject(new GetObjectRequest(bucketName, fileName), file1);
//            return file1;
//        }catch (Exception e){
//            log.error("[oss异常]e",e);
//        }
//        return null;
//
//    }
//
//    /**
//     * 上传文件
//     * @param inputStream
//     * @param fileName
//     */
//    public void uploadFile(InputStream inputStream, String fileName){
//        try {
//            internalOss.putObject(ossProperties.getBucketName(), fileName, inputStream);
//        }catch (Exception e){
//            log.error("[oss异常]e",e);
//        }
//    }
//
//    /**
//     * 上传文件
//     * @param inputStream
//     * @param fileName
//     * @param bucketName
//     */
//    public void uploadFile(InputStream inputStream, String fileName,String bucketName){
//        try {
//            internalOss.putObject(bucketName, fileName, inputStream);
//        }catch (Exception e){
//            log.error("[oss异常]e",e);
//        }
//    }
//
//    /**
//     * 判断文件是否已经上传完成
//     * @param fileName
//     * @return
//     */
//    public boolean isExistFile(String fileName) {
//        try {
//            boolean found = internalOss.doesObjectExist(ossProperties.getBucketName(), fileName);
//            return found;
//        }catch (Exception e){
//            log.error("[oss异常]e",e);
//        }
//        return false;
//    }
//}
