/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.mqtt.publisher;

import com.icetech.mqtt.autoconfigure.MqttConnector;
import com.icetech.mqtt.autoconfigure.MqttConversionService;
import com.icetech.mqtt.properties.MqttProperties;
import java.util.Objects;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MqttPublisher {
    private static final Logger log = LoggerFactory.getLogger(MqttPublisher.class);
    private MqttProperties properties;

    public void send(String topic, Object payload) {
        this.send(MqttConnector.DefaultClientId, topic, payload, MqttConnector.DefaultPublishQos, false, null);
    }

    public void send(String topic, Object payload, IMqttActionListener callback) {
        this.send(MqttConnector.DefaultClientId, topic, payload, MqttConnector.DefaultPublishQos, false, callback);
    }

    public void send(String clientId, String topic, Object payload) {
        this.send(clientId, topic, payload, MqttConnector.getDefaultQosById(clientId), false, null);
    }

    public void send(String clientId, String topic, Object payload, IMqttActionListener callback) {
        this.send(clientId, topic, payload, MqttConnector.getDefaultQosById(clientId), false, callback);
    }

    public void send(String topic, Object payload, int qos, boolean retained) {
        this.send(MqttConnector.DefaultClientId, topic, payload, qos, retained, null);
    }

    public void send(String clientId, String topic, Object payload, int qos, boolean retained) {
        this.send(clientId, topic, payload, qos, retained, null);
    }

    public void send(String topic, Object payload, int qos, boolean retained, IMqttActionListener callback) {
        this.send(MqttConnector.DefaultClientId, topic, payload, qos, retained, callback);
    }

    public void send(String clientId, String topic, Object payload, int qos, boolean retained, IMqttActionListener callback) {
        Assert.isTrue((topic != null && !topic.trim().isEmpty() ? 1 : 0) != 0, (String)"topic cannot be blank.");
        IMqttAsyncClient client = Objects.requireNonNull(MqttConnector.getClientById(clientId));
        byte[] bytes = MqttConversionService.getSharedInstance().toBytes(payload);
        if (bytes == null) {
            return;
        }
        MqttMessage message = this.toMessage(bytes, qos, retained);
        try {
            if (!StringUtils.isEmpty((Object)this.properties.getPubParentTopic())) {
                topic = this.properties.getPubParentTopic() + "/" + topic;
            }
            client.publish(topic, message, null, callback);
        }
        catch (Throwable throwable) {
            log.error("message publish error: {}", (Object)throwable.getMessage(), (Object)throwable);
        }
    }

    private MqttMessage toMessage(byte[] payload, int qos, boolean retained) {
        MqttMessage message = new MqttMessage();
        message.setPayload(payload);
        message.setQos(qos);
        message.setRetained(retained);
        return message;
    }

    public MqttProperties getProperties() {
        return this.properties;
    }

    public void setProperties(MqttProperties properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MqttPublisher)) {
            return false;
        }
        MqttPublisher other = (MqttPublisher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MqttProperties this$properties = this.getProperties();
        MqttProperties other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !this$properties.equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MqttPublisher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MqttProperties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        return result;
    }

    public String toString() {
        return "MqttPublisher(properties=" + this.getProperties() + ")";
    }
}

