/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.mqtt.properties;

import com.icetech.mqtt.properties.ConnectionProperties;
import com.icetech.mqtt.properties.WillProperties;
import com.icetech.mqtt.tools.Tools;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="mqtt")
public class MqttProperties
extends ConnectionProperties {
    private Boolean disable = false;
    private String clientId;
    private String subTopic;
    private String pubParentTopic;
    private Map<String, ConnectionProperties> clients = new LinkedHashMap<String, ConnectionProperties>();

    public Boolean getDisable() {
        return this.disable;
    }

    public void setDisable(Boolean disable) {
        this.disable = disable;
    }

    public String getSubTopic() {
        return this.subTopic;
    }

    public void setSubTopic(String subTopic) {
        this.subTopic = subTopic;
    }

    public String getPubParentTopic() {
        return this.pubParentTopic;
    }

    public void setPubParentTopic(String pubParentTopic) {
        this.pubParentTopic = pubParentTopic;
    }

    public String getClientId() {
        if (StringUtils.isEmpty((Object)super.getAccessKey())) {
            if (StringUtils.isEmpty((Object)this.clientId)) {
                return "default_client";
            }
            return this.clientId;
        }
        return super.getGroupId() + "@@@" + this.getLocalIp();
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Map<String, ConnectionProperties> getClients() {
        return this.clients;
    }

    public void setClients(Map<String, ConnectionProperties> clients) {
        this.clients = clients;
    }

    public void forEach(BiConsumer<String, MqttConnectOptions> biConsumer) {
        MqttConnectOptions defaultOptions = this.toOptions();
        if (defaultOptions != null) {
            biConsumer.accept(this.getClientId(), defaultOptions);
        }
        if (this.clients != null && !this.clients.isEmpty()) {
            this.clients.forEach((? super K id, ? super V prop) -> {
                MqttConnectOptions options = this.toOptions((String)id);
                if (options != null) {
                    biConsumer.accept((String)id, options);
                }
            });
        }
    }

    private MqttConnectOptions toOptions() {
        if (StringUtils.hasLength((String)this.getClientId())) {
            return this.toOptions(this.getClientId());
        }
        return null;
    }

    private MqttConnectOptions toOptions(@NonNull String clientId) {
        ConnectionProperties properties = this.clients.get(clientId);
        if (properties == null) {
            if (clientId.equals(this.getClientId())) {
                properties = this;
            } else {
                return null;
            }
        }
        this.merge(properties);
        return this.toOptions(properties);
    }

    private MqttConnectOptions toOptions(ConnectionProperties properties) {
        WillProperties will;
        MqttConnectOptions options = new MqttConnectOptions();
        options.setMaxReconnectDelay(properties.getMaxReconnectDelay() * 1000);
        options.setKeepAliveInterval(properties.getKeepAliveInterval().intValue());
        options.setConnectionTimeout(properties.getKeepAliveInterval().intValue());
        options.setCleanSession(properties.getCleanSession().booleanValue());
        options.setAutomaticReconnect(properties.getAutomaticReconnect().booleanValue());
        options.setExecutorServiceTimeout(properties.getExecutorServiceTimeout().intValue());
        options.setServerURIs(properties.getUri());
        if (StringUtils.hasLength((String)properties.getUsername()) && StringUtils.hasLength((String)properties.getPassword())) {
            options.setUserName(properties.getUsername());
            options.setPassword(properties.getPassword().toCharArray());
        }
        if (StringUtils.hasLength((String)properties.getAccessKey()) && StringUtils.hasLength((String)properties.getSecretKey())) {
            String userName = "Signature|" + properties.getAccessKey() + "|" + properties.getInstanceId();
            String password = Tools.macSignature(this.getClientId(), properties.getSecretKey());
            options.setUserName(userName);
            options.setPassword(password.toCharArray());
        }
        if (properties.getWill() != null && StringUtils.hasLength((String)(will = properties.getWill()).getTopic()) && StringUtils.hasLength((String)will.getPayload())) {
            options.setWill(will.getTopic(), will.getPayload().getBytes(StandardCharsets.UTF_8), will.getQos().intValue(), will.getRetained().booleanValue());
        }
        return options;
    }

    private void merge(ConnectionProperties target) {
        target.setUri(this.mergeValue(this.getUri(), target.getUri(), new String[]{"tcp://127.0.0.1:1883"}));
        target.setUsername(this.mergeValue(this.getUsername(), target.getUsername(), null));
        target.setPassword(this.mergeValue(this.getPassword(), target.getPassword(), null));
        target.setDefaultPublishQos(this.mergeValue(this.getDefaultPublishQos(), target.getDefaultPublishQos(), 0));
        target.setMaxReconnectDelay(this.mergeValue(this.getMaxReconnectDelay(), target.getMaxReconnectDelay(), 60));
        target.setKeepAliveInterval(this.mergeValue(this.getKeepAliveInterval(), target.getKeepAliveInterval(), 60));
        target.setConnectionTimeout(this.mergeValue(this.getConnectionTimeout(), target.getConnectionTimeout(), 30));
        target.setExecutorServiceTimeout(this.mergeValue(this.getExecutorServiceTimeout(), target.getExecutorServiceTimeout(), 10));
        target.setCleanSession(this.mergeValue(this.getCleanSession(), target.getCleanSession(), true));
        target.setAutomaticReconnect(this.mergeValue(this.getAutomaticReconnect(), target.getAutomaticReconnect(), true));
        target.setWill(this.mergeValue(this.getWill(), target.getWill(), null));
        target.setEnableSharedSubscription(this.mergeValue(this.getEnableSharedSubscription(), target.getEnableSharedSubscription(), true));
        if (target.getWill() != null && this.getWill() != null) {
            WillProperties will = this.getWill();
            WillProperties targetWill = target.getWill();
            targetWill.setTopic(this.mergeValue(will.getTopic(), targetWill.getTopic(), null));
            targetWill.setPayload(this.mergeValue(will.getPayload(), targetWill.getPayload(), null));
            targetWill.setQos(this.mergeValue(will.getQos(), targetWill.getQos(), 0));
            targetWill.setRetained(this.mergeValue(will.getRetained(), targetWill.getRetained(), false));
        }
    }

    private <T> T mergeValue(T parentValue, T targetValue, T defaultValue) {
        if (parentValue == null && targetValue == null) {
            return defaultValue;
        }
        if (targetValue == null) {
            return parentValue;
        }
        return targetValue;
    }

    public boolean isSharedEnable(String clientId) {
        if (clientId.equals(this.getClientId())) {
            return this.getEnableSharedSubscription();
        }
        ConnectionProperties properties = this.clients.get(clientId);
        if (properties == null) {
            return false;
        }
        return properties.getEnableSharedSubscription();
    }

    public int getDefaultPublishQos(String clientId) {
        if (clientId.equals(this.getClientId())) {
            return this.getDefaultPublishQos();
        }
        ConnectionProperties properties = this.clients.get(clientId);
        if (properties == null) {
            return 0;
        }
        return properties.getDefaultPublishQos();
    }

    public String getLocalIp() {
        try {
            InetAddress ia = InetAddress.getLocalHost();
            String localIp = ia.getHostAddress();
            return localIp;
        }
        catch (Exception e) {
            return "default_client";
        }
    }
}

