/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.mqtt.autoconfigure;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.icetech.mqtt.convert.PayloadDeserialize;
import com.icetech.mqtt.convert.PayloadSerialize;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.StringUtils;

@Order(value=1001)
@AutoConfigureAfter(value={JacksonAutoConfiguration.class})
@ConditionalOnClass(value={ObjectMapper.class})
@Configuration
public class PayloadJacksonAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(PayloadJacksonAutoConfiguration.class);

    @Bean
    @Order(value=1001)
    @ConditionalOnMissingBean(value={ObjectMapper.class})
    public ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.registerModule((Module)new MqttDefaultJacksonModule());
        return objectMapper;
    }

    @Bean
    @Order(value=1002)
    @ConditionalOnMissingBean(value={PayloadSerialize.class})
    public PayloadSerialize payloadSerialize(ObjectMapper objectMapper) {
        return source -> {
            try {
                return objectMapper.writeValueAsBytes(source);
            }
            catch (JsonProcessingException e) {
                log.warn("Payload serialize error: {}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        };
    }

    @Bean
    @Order(value=1002)
    @ConditionalOnMissingBean(value={PayloadDeserialize.class})
    public PayloadDeserialize payloadDeserialize(final ObjectMapper objectMapper) {
        return new PayloadDeserialize(){

            public <T> Converter<byte[], T> getConverter(Class<T> targetType) {
                return source -> {
                    try {
                        if (targetType == String.class) {
                            return new String((byte[])source, StandardCharsets.UTF_8);
                        }
                        return objectMapper.readValue(source, targetType);
                    }
                    catch (IOException e) {
                        log.warn("Payload deserialize error: {}", (Object)e.getMessage(), (Object)e);
                        return null;
                    }
                };
            }
        };
    }

    public static class MqttDefaultJacksonModule
    extends SimpleModule {
        public static final Version VERSION = VersionUtil.parseVersion((String)"1.1.0", (String)"com.github.wangzhiwei", (String)"spring-boot-starter-mqtt");
        private static final ZoneId ZONE_ID = ZoneId.of("GMT+8");
        private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
        private static final JsonSerializer<LocalDateTime> LOCAL_DATE_TIME_JSON_SERIALIZER = new JsonSerializer<LocalDateTime>(){

            public void serialize(LocalDateTime value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                if (value == null) {
                    gen.writeNull();
                } else {
                    gen.writeString(value.atZone(ZONE_ID).format(DATE_TIME_FORMATTER));
                }
            }
        };
        private static final JsonSerializer<LocalDate> LOCAL_DATE_JSON_SERIALIZER = new JsonSerializer<LocalDate>(){

            public void serialize(LocalDate value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                if (value == null) {
                    gen.writeNull();
                } else {
                    gen.writeString(value.format(DATE_FORMATTER));
                }
            }
        };
        private static final JsonSerializer<LocalTime> LOCAL_TIME_JSON_SERIALIZER = new JsonSerializer<LocalTime>(){

            public void serialize(LocalTime value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                if (value == null) {
                    gen.writeNull();
                } else {
                    gen.writeString(value.format(TIME_FORMATTER));
                }
            }
        };
        private static final JsonSerializer<Date> DATE_JSON_SERIALIZER = new JsonSerializer<Date>(){

            public void serialize(Date value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                if (value == null) {
                    gen.writeNull();
                } else {
                    gen.writeString(DATE_TIME_FORMATTER.format(value.toInstant().atZone(ZONE_ID)));
                }
            }
        };
        private static final JsonDeserializer<LocalDateTime> LOCAL_DATE_TIME_JSON_DESERIALIZER = new JsonDeserializer<LocalDateTime>(){

            public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                String value = p.getValueAsString();
                if (StringUtils.hasLength((String)value)) {
                    return LocalDateTime.parse(value, DATE_TIME_FORMATTER);
                }
                return null;
            }
        };
        private static final JsonDeserializer<LocalDate> LOCAL_DATE_JSON_DESERIALIZER = new JsonDeserializer<LocalDate>(){

            public LocalDate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                String value = p.getValueAsString();
                if (StringUtils.hasLength((String)value)) {
                    return LocalDate.parse(value, DATE_FORMATTER);
                }
                return null;
            }
        };
        private static final JsonDeserializer<LocalTime> LOCAL_TIME_JSON_DESERIALIZER = new JsonDeserializer<LocalTime>(){

            public LocalTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                String value = p.getValueAsString();
                if (StringUtils.hasLength((String)value)) {
                    return LocalTime.parse(value, TIME_FORMATTER);
                }
                return null;
            }
        };
        private static final JsonDeserializer<Date> DATE_JSON_DESERIALIZER = new JsonDeserializer<Date>(){

            public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                String value = p.getValueAsString();
                if (StringUtils.hasLength((String)value)) {
                    return Date.from(LocalDateTime.parse(value, DATE_TIME_FORMATTER).atZone(ZONE_ID).toInstant());
                }
                return null;
            }
        };

        public MqttDefaultJacksonModule() {
            super(VERSION);
            this.addSerializer(LocalDateTime.class, LOCAL_DATE_TIME_JSON_SERIALIZER);
            this.addSerializer(LocalDate.class, LOCAL_DATE_JSON_SERIALIZER);
            this.addSerializer(LocalTime.class, LOCAL_TIME_JSON_SERIALIZER);
            this.addSerializer(Date.class, DATE_JSON_SERIALIZER);
            this.addDeserializer(LocalDateTime.class, LOCAL_DATE_TIME_JSON_DESERIALIZER);
            this.addDeserializer(LocalDate.class, LOCAL_DATE_JSON_DESERIALIZER);
            this.addDeserializer(LocalTime.class, LOCAL_TIME_JSON_DESERIALIZER);
            this.addDeserializer(Date.class, DATE_JSON_DESERIALIZER);
        }
    }
}

