/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.mqtt.autoconfigure;

import com.icetech.mqtt.annotation.MqttSubscribe;
import com.icetech.mqtt.subscriber.MqttSubscriber;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

@Component
public class MqttSubscribeProcessor
implements BeanPostProcessor {
    public static final LinkedList<MqttSubscriber> SUBSCRIBERS = new LinkedList();
    @Value(value="${mqtt.disable:false}")
    private Boolean disable;
    @Value(value="${mqtt.sub-topic}")
    private String subTopic;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.disable == null || !this.disable.booleanValue()) {
            Method[] methods;
            for (Method method : methods = bean.getClass().getMethods()) {
                if (!method.isAnnotationPresent(MqttSubscribe.class)) continue;
                SUBSCRIBERS.add(MqttSubscriber.of(bean, method, this.subTopic));
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

