package com.icetech.mqtt.tools;

import org.springframework.util.Base64Utils;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

/**
 * Created by wangzhiwei
 */
public class Tools {

    /**
     * @param text 要签名的文本
     * @param secretKey 阿里云MQ secretKey
     * @return 加密后的字符串
     * @throws InvalidKeyException
     * @throws NoSuchAlgorithmException
     */
    public static String macSignature(String text, String secretKey){
        try {
            Charset charset = Charset.forName("UTF-8");
            String algorithm = "HmacSHA1";
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(secretKey.getBytes(charset), algorithm));
            byte[] bytes = mac.doFinal(text.getBytes(charset));
            return new String(Base64Utils.encode(bytes), charset);
        }catch (Exception e){
            return null;
        }
    }
}
