package com.icetech.excel.convert;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.convert.Convert;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ReadConverterContext;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.icetech.excel.anno.ExcelDictFormat;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Field;
import java.util.Objects;

/**
 * 字典格式化转换处理
 *
 * @author wgy
 */
@Slf4j
public class ExcelDictConvert implements Converter<Object> {

	@Override
	public Class<Object> supportJavaTypeKey() {
		return Object.class;
	}

	@Override
	public CellDataTypeEnum supportExcelTypeKey() {
		return null;
	}

	@Override
	public Object convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
		ExcelDictFormat anno = getAnnotation(contentProperty.getField());
		String label = cellData.getStringValue();
		return Convert.convert(contentProperty.getField().getType(), DictContext.getCurrentContext().getValue(label, anno));
	}

	@Override
	public Object convertToJavaData(ReadConverterContext<?> context) throws Exception {
		return Converter.super.convertToJavaData(context);
	}

	@Override
	public WriteCellData<?> convertToExcelData(WriteConverterContext<Object> context) throws Exception {
		if (Objects.isNull(context.getValue())) {
			return new WriteCellData<>("");
		}
		ExcelDictFormat anno = getAnnotation(context.getContentProperty().getField());
		String value = Convert.toStr(context.getValue());
		return new WriteCellData<>(DictContext.getCurrentContext().getLabel(value, anno));
	}

	private ExcelDictFormat getAnnotation(Field field) {
		return AnnotationUtil.getAnnotation(field, ExcelDictFormat.class);
	}
}
