/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.excel.utils;

import cn.hutool.core.util.IdUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellExtraTypeEnum;
import com.alibaba.excel.metadata.CellExtra;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.FileUtil;
import com.icetech.common.utils.StringUtils;
import com.icetech.excel.convert.DictContext;
import com.icetech.excel.convert.ExcelBigNumberConvert;
import com.icetech.excel.listener.ExcelListener;
import com.icetech.excel.listener.ExcelResult;
import com.icetech.excel.listener.UploadExtraDataListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);

    public static <T> List<T> importExcel(InputStream is, Class<T> clazz) {
        return ((ExcelReaderBuilder)EasyExcel.read((InputStream)is).head(clazz)).autoCloseStream(Boolean.valueOf(false)).sheet().doReadSync();
    }

    public static <T> List<T> importExcelMerge(InputStream is, Class<T> clazz) {
        UploadExtraDataListener listener = new UploadExtraDataListener(1);
        try {
            EasyExcel.read((InputStream)is, clazz, listener).extraRead(CellExtraTypeEnum.MERGE).sheet().doRead();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        List<CellExtra> extraMergeInfoList = listener.getExtraMergeInfoList();
        if (CollectionUtils.isEmpty(extraMergeInfoList)) {
            return listener.getData();
        }
        return ExcelUtil.explainMergeData(listener.getData(), extraMergeInfoList, 1);
    }

    private static <T> List<T> explainMergeData(List<T> data, List<CellExtra> extraMergeInfoList, Integer headRowNumber) {
        extraMergeInfoList.forEach(cellExtra -> {
            int firstRowIndex = cellExtra.getFirstRowIndex() - headRowNumber;
            int lastRowIndex = cellExtra.getLastRowIndex() - headRowNumber;
            int firstColumnIndex = cellExtra.getFirstColumnIndex();
            int lastColumnIndex = cellExtra.getLastColumnIndex();
            Object initValue = ExcelUtil.getInitValueFromList(firstRowIndex, firstColumnIndex, data);
            for (int i = firstRowIndex; i <= lastRowIndex; ++i) {
                for (int j = firstColumnIndex; j <= lastColumnIndex; ++j) {
                    ExcelUtil.setInitValueToList(initValue, i, j, data);
                }
            }
        });
        return data;
    }

    private static <T> Object getInitValueFromList(Integer firstRowIndex, Integer firstColumnIndex, List<T> data) {
        Object filedValue = null;
        T object = data.get(firstRowIndex);
        for (Field field : object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            ExcelProperty annotation = field.getAnnotation(ExcelProperty.class);
            if (annotation == null || annotation.index() != firstColumnIndex.intValue()) continue;
            try {
                filedValue = field.get(object);
                break;
            }
            catch (IllegalAccessException e) {
                throw new ResponseBodyException("500", "\u89e3\u6790\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38!");
            }
        }
        return filedValue;
    }

    public static <T> void setInitValueToList(Object filedValue, Integer rowIndex, Integer columnIndex, List<T> data) {
        T object = data.get(rowIndex);
        for (Field field : object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            ExcelProperty annotation = field.getAnnotation(ExcelProperty.class);
            if (annotation == null || annotation.index() != columnIndex.intValue()) continue;
            try {
                field.set(object, filedValue);
                break;
            }
            catch (IllegalAccessException e) {
                throw new ResponseBodyException("500", "\u89e3\u6790\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38!");
            }
        }
    }

    public static <T> ExcelResult<T> importExcel(InputStream is, Class<?> clazz, ExcelListener<T> listener) {
        EasyExcel.read((InputStream)is, clazz, listener).sheet().doRead();
        return listener.getExcelResult();
    }

    public static <T> void exportExcel(List<T> list, String sheetName, Class<?> clazz, HttpServletResponse response) {
        try {
            String filename = ExcelUtil.encodingFilename(sheetName);
            response.reset();
            FileUtil.setAttachmentResponseHeader((HttpServletResponse)response, (String)filename);
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=UTF-8");
            ServletOutputStream os = response.getOutputStream();
            ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)os, clazz).autoCloseStream(Boolean.valueOf(false)).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).registerConverter((Converter)new ExcelBigNumberConvert())).sheet(sheetName).doWrite(list);
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u51faExcel\u5f02\u5e38");
        }
        finally {
            DictContext.getCurrentContext().unset();
        }
    }

    public static <T> void exportExcelCors(List<T> list, String sheetName, Class<?> clazz, HttpServletResponse response) {
        try {
            String filename = ExcelUtil.encodingFilename(sheetName);
            response.reset();
            FileUtil.setAttachmentResponseHeader((HttpServletResponse)response, (String)filename);
            response.addHeader("Access-Control-Allow-Origin", "*");
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=UTF-8");
            ServletOutputStream os = response.getOutputStream();
            ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)os, clazz).autoCloseStream(Boolean.valueOf(false)).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).registerConverter((Converter)new ExcelBigNumberConvert())).sheet(sheetName).doWrite(list);
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u51faExcel\u5f02\u5e38");
        }
        finally {
            DictContext.getCurrentContext().unset();
        }
    }

    public static void exportListExcel(List<List<String>> listHead, List<List<Object>> listData, String sheetName, HttpServletResponse response) {
        try {
            String filename = ExcelUtil.encodingFilename(sheetName);
            response.reset();
            FileUtil.setAttachmentResponseHeader((HttpServletResponse)response, (String)filename);
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=UTF-8");
            ServletOutputStream os = response.getOutputStream();
            ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)os).autoCloseStream(Boolean.valueOf(false)).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).registerConverter((Converter)new ExcelBigNumberConvert())).head(listHead)).sheet(sheetName).doWrite(listData);
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u51faExcel\u5f02\u5e38");
        }
        finally {
            DictContext.getCurrentContext().unset();
        }
    }

    public static void exportListExcelCors(List<List<String>> listHead, List<List<Object>> listData, String sheetName, HttpServletResponse response) {
        try {
            String filename = ExcelUtil.encodingFilename(sheetName);
            response.reset();
            FileUtil.setAttachmentResponseHeader((HttpServletResponse)response, (String)filename);
            response.addHeader("Access-Control-Allow-Origin", "*");
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=UTF-8");
            ServletOutputStream os = response.getOutputStream();
            ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)os).autoCloseStream(Boolean.valueOf(false)).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).registerConverter((Converter)new ExcelBigNumberConvert())).head(listHead)).sheet(sheetName).doWrite(listData);
        }
        catch (IOException e) {
            throw new RuntimeException("\u5bfc\u51faExcel\u5f02\u5e38");
        }
        finally {
            DictContext.getCurrentContext().unset();
        }
    }

    public static String convertByExp(String propertyValue, String converterExp, String separator) {
        String[] convertSource;
        StringBuilder propertyString = new StringBuilder();
        block0: for (String item : convertSource = converterExp.split(",")) {
            String[] itemArray = item.split("=");
            if (StringUtils.containsAny((CharSequence)separator, (CharSequence)propertyValue)) {
                for (String value : propertyValue.split(separator)) {
                    if (!itemArray[0].equals(value)) continue;
                    propertyString.append(itemArray[1] + separator);
                    continue block0;
                }
                continue;
            }
            if (!itemArray[0].equals(propertyValue)) continue;
            return itemArray[1];
        }
        return StringUtils.stripEnd((String)propertyString.toString(), (String)separator);
    }

    public static String reverseByExp(String propertyValue, String converterExp, String separator) {
        String[] convertSource;
        StringBuilder propertyString = new StringBuilder();
        block0: for (String item : convertSource = converterExp.split(",")) {
            String[] itemArray = item.split("=");
            if (StringUtils.containsAny((CharSequence)separator, (CharSequence)propertyValue)) {
                for (String value : propertyValue.split(separator)) {
                    if (!itemArray[1].equals(value)) continue;
                    propertyString.append(itemArray[0] + separator);
                    continue block0;
                }
                continue;
            }
            if (!itemArray[1].equals(propertyValue)) continue;
            return itemArray[0];
        }
        return StringUtils.stripEnd((String)propertyString.toString(), (String)separator);
    }

    public static String encodingFilename(String filename) {
        return IdUtil.fastSimpleUUID() + "_" + filename + ".xlsx";
    }

    private ExcelUtil() {
    }
}

