/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.excel.convert;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ReadConverterContext;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelBigNumberConvert
implements Converter<Long> {
    private static final Logger log = LoggerFactory.getLogger(ExcelBigNumberConvert.class);

    public Class<Long> supportJavaTypeKey() {
        return Long.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public Long convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return Convert.toLong((Object)cellData.getData());
    }

    public Long convertToJavaData(ReadConverterContext<?> context) throws Exception {
        return (Long)super.convertToJavaData(context);
    }

    public WriteCellData<?> convertToExcelData(WriteConverterContext<Long> context) throws Exception {
        String str;
        if (ObjectUtil.isNotNull((Object)context.getValue()) && (str = Convert.toStr((Object)context.getValue())).length() > 15) {
            return new WriteCellData(str);
        }
        return new WriteCellData(new BigDecimal((Long)context.getValue()));
    }
}

