package com.icetech.excel.convert;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.util.DateUtils;

import java.text.ParseException;
import java.util.Date;

/**
 * @description: 秒时间戳 格式化字符串
 * @auth: wangzhiwei
 * @date: 2023-07-31  11:03
 * @Version: 1.0
 */
public class TimestampSecondStringConverter implements Converter<Long> {


    public Class<?> supportJavaTypeKey() {
        return Date.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public Long convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws ParseException {
        return contentProperty != null && contentProperty.getDateTimeFormatProperty() != null ? DateUtils.parseDate(cellData.getStringValue(), contentProperty.getDateTimeFormatProperty().getFormat()).getTime()/1000 : DateUtils.parseDate(cellData.getStringValue(), null).getTime()/1000;
    }

    public WriteCellData<?> convertToExcelData(Long value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        return contentProperty != null && contentProperty.getDateTimeFormatProperty() != null ? new WriteCellData(DateUtils.format(new Date(value*1000), contentProperty.getDateTimeFormatProperty().getFormat())) : new WriteCellData(DateUtils.format(new Date(value*1000), "yyyy-MM-dd HH:mm:ss"));
    }
}
