package com.icetech.db.hikari;

import java.sql.SQLException;
import java.sql.SQLTimeoutException;

import com.zaxxer.hikari.SQLExceptionOverride;

public class HikariSQLExceptionOverride implements SQLExceptionOverride {
    public Override adjudicate(SQLException sqlException) {
        if (sqlException instanceof SQLTimeoutException
                && "Statement cancelled due to timeout or client request".equals(sqlException.getMessage())) {
            return Override.DO_NOT_EVICT;
        }

        return Override.CONTINUE_EVICT;
    }
}
