package com.icetech.db.mybatis.generator;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.converts.MySqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.po.TableFill;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.icetech.db.mybatis.DateMetaObjectHandler;

import java.util.ArrayList;
import java.util.Objects;

/**
 * Description 代码生成器
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2021/4/29 17:31 PM
 */
public class GeneratorUtil {

    private static final String DATE_TIME = "datetime";
    private static final String TIMESTAMP = "timestamp";

    /**
     * Description: 代码生成
     *
     * @param generateConfig generateConfig
     * @author wgy 2019-11-14 06:09:31
     */
    public static void execute(GenerateConfig generateConfig) {
        AutoGenerator mpg = new AutoGenerator();
        // 全局配置
        GlobalConfig gc = new GlobalConfig();
        gc.setOutputDir(generateConfig.getOutputDir());
        gc.setFileOverride(true);
        //ActiveRecord特性
        gc.setActiveRecord(false);
        // XML ResultMap
        gc.setBaseResultMap(true);
        // XML columnList
        gc.setBaseColumnList(true);
        gc.setEnableCache(false);
        // 自动打开输出目录
        gc.setOpen(false);
        gc.setAuthor(generateConfig.getAuthor());
        //主键策略
        gc.setIdType(IdType.AUTO);
        // 自定义文件命名，注意 %s 会自动填充表实体属性！
        gc.setServiceName("%sService");
        gc.setServiceImplName("%sServiceImpl");
        mpg.setGlobalConfig(gc);
        // 数据源配置
        DataSourceConfig dsc = new DataSourceConfig();
        dsc.setDbType(generateConfig.getDbType());
        dsc.setDriverName(generateConfig.getJdbcDriver());
        dsc.setUrl(generateConfig.getJdbcUrl());
        dsc.setUsername(generateConfig.getJdbcUserName());
        dsc.setPassword(generateConfig.getJdbcPassword());
        dsc.setTypeConvert(new MySqlTypeConvert() {
            // 自定义数据库表字段类型转换【可选】
            @Override
            public DbColumnType processTypeConvert(GlobalConfig globalConfig, String fieldType) {
                //将数据库中datetime转换成date
                if (fieldType.toLowerCase().contains(DATE_TIME) || fieldType.toLowerCase().contains(TIMESTAMP)) {
                    return DbColumnType.DATE;
                }
                return (DbColumnType) super.processTypeConvert(globalConfig, fieldType);
            }
        });
        mpg.setDataSource(dsc);
        // 策略配置
        StrategyConfig strategy = setStrategy(generateConfig);
        mpg.setStrategy(strategy);
        // 包配置
        PackageConfig pc = new PackageConfig();
        //父包名
        pc.setParent(generateConfig.getParentPackage());
        //父包模块名
        pc.setModuleName(generateConfig.getModuleName());
        //实体类父包
        pc.setEntity("model");
        //mapper父包
        pc.setMapper("dao");
        pc.setServiceImpl("service.impl");
        pc.setService("service");
        mpg.setPackageInfo(pc);
        // 执行生成
        mpg.execute();
    }

    /**
     * Description: 设置策略
     *
     * @param generateConfig generateConfig
     * @author wgy 2019-11-14 05:21:43
     */
    private static StrategyConfig setStrategy(GenerateConfig generateConfig) {
        StrategyConfig strategy = new StrategyConfig();
        strategy.setCapitalMode(false);
        strategy.setRestControllerStyle(true);
        strategy.setEntityLombokModel(true);
        strategy.setEntityTableFieldAnnotationEnable(false);
        // 此处可以移除表前缀表前缀
        if (Objects.nonNull(generateConfig.getTablePrefix())) {
            strategy.setTablePrefix(generateConfig.getTablePrefix());
        }
        // 表名生成策略
        strategy.setNaming(NamingStrategy.underline_to_camel);
        // 字段生成策略
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        // mapper 父类
        strategy.setSuperMapperClass("com.icetech.db.mybatis.base.mapper.SuperMapper");
        // 接口父类
        strategy.setSuperServiceClass("com.icetech.db.mybatis.base.service.IBaseService");
        // 接口实现类父类
        strategy.setSuperServiceImplClass("com.icetech.db.mybatis.base.service.impl.BaseServiceImpl");
        // 需要生成的表
        strategy.setInclude(generateConfig.getIncludeTables());
        // 公共字段填充
        ArrayList<TableFill> tableFills = new ArrayList<>();
        tableFills.add(new TableFill(DateMetaObjectHandler.CREATE_TIME_FIELD, FieldFill.INSERT));
        tableFills.add(new TableFill(DateMetaObjectHandler.UPDATE_TIME_FIELD, FieldFill.UPDATE));
        strategy.setTableFillList(tableFills);
        return strategy;
    }
}
