package com.icetech.db.mybatis;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import org.apache.ibatis.reflection.MetaObject;

import java.util.Date;

/**
 * Description 自动填充字段
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2021/4/28 12:24 PM
 */
public class DateMetaObjectHandler implements MetaObjectHandler {
    public final static String CREATE_TIME_FIELD = "create_time";
    public final static String UPDATE_TIME_FIELD = "update_time";
    public final static String CREATE_TIME = "createTime";
    public final static String UPDATE_TIME = "updateTime";

    /**
     * Description: 插入填充，字段为空自动填充
     * 
     * @param metaObject metaObject
     */
    @Override
    public void insertFill(MetaObject metaObject) {
        Object createDate = getFieldValByName(CREATE_TIME, metaObject);
        Object lastModifyDate = getFieldValByName(UPDATE_TIME, metaObject);
        Date date = new Date();
        if (createDate == null) {
            setFieldValByName(CREATE_TIME, date, metaObject);
        }
        if (lastModifyDate == null) {
            setFieldValByName(UPDATE_TIME, date, metaObject);
        }
    }

    /**
     * Description: 更新填充
     * 
     * @param metaObject metaObject
     */
    @Override
    public void updateFill(MetaObject metaObject) {
        setFieldValByName(UPDATE_TIME, new Date(), metaObject);
    }
}