/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.db.config;

import com.baomidou.mybatisplus.core.parser.ISqlParserFilter;
import com.baomidou.mybatisplus.core.parser.SqlParserHelper;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.icetech.common.content.TenantContextHolder;
import com.icetech.common.properties.TenantProperties;
import com.icetech.common.utils.StringUtils;
import java.util.Collection;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.CollectionUtils;

@EnableConfigurationProperties(value={TenantProperties.class})
public class TenantAutoConfigure {
    @Autowired
    private TenantProperties tenantProperties;

    @Bean
    public TenantLineHandler tenantLineHandler() {
        return new TenantLineHandler(){

            public Expression getTenantId() {
                String tenant = TenantContextHolder.getTenantId();
                if (tenant != null) {
                    return new StringValue(TenantContextHolder.getTenantId());
                }
                return new NullValue();
            }

            public boolean ignoreTable(String tableName) {
                String tenant = TenantContextHolder.getTenantId();
                if (StringUtils.isEmpty((CharSequence)tenant)) {
                    return true;
                }
                if (!CollectionUtils.isEmpty((Collection)TenantAutoConfigure.this.tenantProperties.getIncludeTables())) {
                    return TenantAutoConfigure.this.tenantProperties.getIncludeTables().stream().noneMatch(e -> e.equalsIgnoreCase(tableName));
                }
                return TenantAutoConfigure.this.tenantProperties.getIgnoreTables().stream().anyMatch(e -> e.equalsIgnoreCase(tableName));
            }

            public String getTenantIdColumn() {
                return TenantAutoConfigure.this.tenantProperties.getTenantIdColumn();
            }
        };
    }

    @Bean
    public ISqlParserFilter sqlParserFilter() {
        return metaObject -> {
            MappedStatement ms = SqlParserHelper.getMappedStatement((MetaObject)metaObject);
            return this.tenantProperties.getIgnoreSqlList().stream().anyMatch(e -> e.equalsIgnoreCase(ms.getId()));
        };
    }
}

