package com.icetech.common.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import org.springframework.util.AntPathMatcher;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 字符串工具类。
 *
 * @author carver.gu
 * @since 1.0, Sep 12, 2009
 */
public class StringUtils extends org.apache.commons.lang3.StringUtils {
    public static String toString(Object obj) {
        if (obj == null)
            return null;

        return String.valueOf(obj);
    }

    public static boolean isBlankOrNullChar(CharSequence content) {
        return isBlank(content) || equalsIgnoreCase(content, "null");
    }

    public static boolean isNotBlankOrNullChar(CharSequence content) {
        return !isBlankOrNullChar(content);
    }

    /**
     * 把通用字符编码的字符串转化为汉字编码。
     */
    public static String unicodeToChinese(String unicode) {
        StringBuilder out = new StringBuilder();
        if (isNotBlank(unicode)) {
            for (int i = 0; i < unicode.length(); i++) {
                out.append(unicode.charAt(i));
            }
        }
        return out.toString();
    }

    /**
     * 过滤不可见字符
     */
    public static String stripNonValidXMLCharacters(String input) {
        if (isBlank(input))
            return "";
        StringBuilder out = new StringBuilder();
        char current;
        for (int i = 0; i < input.length(); i++) {
            current = input.charAt(i);
            if (current == 0x9 || current == 0xA || current == 0xD || current >= 0x20 && current <= 0xD7FF || current >= 0xE000 && current <= 0xFFFD)
                out.append(current);
        }
        return out.toString();
    }

    private static final Pattern PATTERN_BLANK = Pattern.compile("\\s*|\t|\r|\n");
    /**
     * 过虑空格回车tab符号
     *
     * @param str
     * @return
     */
    public static String replaceBlank(String str) {
        String dest = "";
        if (isNotBlank(str)) {
            Matcher m = PATTERN_BLANK.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }


    /**
     * 按字节大小切割字符串
     *
     * @param value
     * @param length
     * @return
     */
    public static List<String> splitBySize(String value, int length) {
        char[] cs = value.toCharArray();
        StringBuilder result = new StringBuilder(length);
        List<String> resultList = new ArrayList<String>(value.getBytes().length / length + 1);
        int index = 0;
        for (char c : cs) {
            index += String.valueOf(c).getBytes().length;
            if (index >= length) {
                result.append(c);
                resultList.add(result.toString());
                result.delete(0, index);
                index = 0;
            } else {
                result.append(c);
            }
        }
        if (result.length() > 0) {
            resultList.add(result.toString());
        }
        return resultList;
    }

    private static final Pattern PATTERN_BRACE = Pattern.compile("\\{([^\\{\\}]+)\\}");
    /**
     * 提取大括号中的内容
     * @param content
     * @return
     */
    public static String[] findBraceValue(String content) {
        Matcher m = PATTERN_BRACE.matcher(content);
        List<String> list = new LinkedList<>();
        while (m.find()) {
            list.add(m.group(1));
        }
        String[] strings = new String[list.size()];
        return list.toArray(strings);
    }

    /**
     * 首字母转大写
     * @param content
     * @return
     */
    public static String toUpperCaseFirstOne(String content) {
        if (Character.isUpperCase(content.charAt(0))) {
            return content;
        }

        char[] ch = content.toCharArray();
        if (ch[0] >= 'a' && ch[0] <= 'z') {
            ch[0] = (char) (ch[0] - 32);
        }
        return new String(ch);
    }

    /**
     * 首字母转小写
     * @param content
     * @return
     */
    public static String toLowerCaseFirstOne(String content) {
        if (Character.isUpperCase(content.charAt(0))) {
            return content;
        }

        char[] ch = content.toCharArray();
        if (ch[0] >= 'a' && ch[0] <= 'z') {
            ch[0] = (char) (ch[0] + 32);
        }
        return new String(ch);
    }

    public static String getUrlParamsByMap(Map<String, Object> map) {
        if (map == null) {
            return "";
        } else {
            StringBuffer sb = new StringBuffer();
            Iterator var2 = map.entrySet().iterator();

            while(var2.hasNext()) {
                Map.Entry<String, Object> entry = (Map.Entry)var2.next();
                sb.append((String)entry.getKey() + "=" + entry.getValue());
                sb.append("&");
            }

            String s = sb.toString();
            if (s.endsWith("&")) {
                s = org.apache.commons.lang3.StringUtils.substringBeforeLast(s, "&");
            }

            return s;
        }
    }

    /**
     * 非空返回int值 空或出错返回零
     */
    public static int getInt(Object obj) {
        return getInt(obj, 0);
    }

    /**
     * 非空返回int值 空或出错返回默认值
     */
    public static int getInt(Object obj, int defArg) {
        try {
            return Integer.parseInt(getString(obj, defArg));
        } catch (NumberFormatException e) {
            return defArg;
        }
    }

    /**
     * 非空返回String值 空或出错返回默认值
     */
    public static String getString(Object obj, Object defStr) {
        return Objects.isNull(obj) ? String.valueOf(defStr) : String.valueOf(obj);
    }

    /**
     * 查找指定字符串是否包含指定字符串列表中的任意一个字符串同时串忽略大小写
     *
     * @param cs                  指定字符串
     * @param searchCharSequences 需要检查的字符串数组
     * @return 是否包含任意一个字符串
     */
    public static boolean containsAnyIgnoreCase(CharSequence cs, CharSequence... searchCharSequences) {
        return StrUtil.containsAnyIgnoreCase(cs, searchCharSequences);
    }

    /**
     * 查找指定字符串是否匹配指定字符串列表中的任意一个字符串
     *
     * @param str  指定字符串
     * @param strs 需要检查的字符串数组
     * @return 是否匹配
     */
    public static boolean matches(String str, List<String> strs) {
        if (isEmpty(str) || CollUtil.isEmpty(strs)) {
            return false;
        }
        for (String pattern : strs) {
            if (isMatch(pattern, str)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 判断url是否与规则配置:
     * ? 表示单个字符;
     * * 表示一层路径内的任意字符串，不可跨层级;
     * ** 表示任意层路径;
     *
     * @param pattern 匹配规则
     * @param url     需要匹配的url
     * @return
     */
    public static boolean isMatch(String pattern, String url) {
        AntPathMatcher matcher = new AntPathMatcher();
        return matcher.match(pattern, url);
    }
}
