package com.icetech.common.utils;

import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

@Slf4j
public class JsonUtils {

    private static ObjectMapper OBJECT_MAPPER = SpringUtils.getBean(ObjectMapper.class);
    
    /**
     * 转换对象为字符串
     */
    public static String toString(Object object) {
        if (object == null) {
            return null;
        }
        return JSON.toJSONString(object);
    }

    public static JSONObject parseObject(String json) {
        if (StringUtils.isBlank(json)) {
            return null;
        }
        return JSON.parseObject(json, Feature.OrderedField);
    }

    /**
     * 将字符串转换为Bean对象
     */
    public static <T> T parseObject(String json, Class<?> clazz, Class<?>... classes) {
        if (StringUtils.isBlank(json)) {
            return null;
        }
        if (classes == null || classes.length == 0) {
            return JSON.parseObject(json, (Type) clazz, Feature.OrderedField);
        }

        return JSON.parseObject(json, ReflectUtils.getLoopWrapperType(clazz, classes), Feature.OrderedField);
    }

    public static <T> T parseObject(JSONObject jsonObj, Class<?> clazz, Class<?>... classes) {
        if (jsonObj == null) {
            return null;
        }
        if (classes == null || classes.length == 0) {
            return jsonObj.toJavaObject((Type) clazz);
        }

        return jsonObj.toJavaObject(ReflectUtils.getLoopWrapperType(clazz, classes));
    }

    public static Map<String, Object> parseMap(String json) {
        return parseObject(json);
    }

    public static <K,V> Map<K, V> parseMap(String json, Class<K> keyClass, Class<V> valueClass) {
        if (json == null) {
            return null;
        }

        return JSON.parseObject(json, ReflectUtils.getWrapperType(Map.class, keyClass, valueClass), Feature.OrderedField);
    }

    public static Map<String, String> parseStringMap(String json) {
        return parseMap(json, String.class, String.class);
    }

    public static <K,V> Map<K, V> parseMap(JSONObject jsonObj, Class<K> keyClass, Class<V> valueClass) {
        if (jsonObj == null) {
            return null;
        }

        return jsonObj.toJavaObject(ReflectUtils.getWrapperType(Map.class, keyClass, valueClass));
    }

    public static JSONArray parseArray(String json) {
        if (StringUtils.isBlank(json)) {
            return null;
        }
        return JSON.parseArray(json);
    }

    public static <T> List<T> parseArray(String json, Class<?> clazz, Class<?>... classes) {
        if (StringUtils.isBlank(json)) {
            return null;
        }
        if (classes == null || classes.length == 0) {
            return JSON.parseObject(json, ReflectUtils.getWrapperType(List.class, clazz), Feature.OrderedField);
        }
        Class<?>[] paramClass = new Class<?>[classes.length + 1];
        paramClass[0] = clazz;
        System.arraycopy(classes, 0, paramClass, 1, classes.length);
        return JSON.parseObject(json, ReflectUtils.getLoopWrapperType(List.class, paramClass), Feature.OrderedField);
    }

    public static <T> List<T> parseArray(JSONArray jsonArray, Class<?> clazz, Class<?>... classes) {
        if (jsonArray == null) {
            return null;
        }
        if (classes == null || classes.length == 0) {
            return jsonArray.toJavaObject(ReflectUtils.getWrapperType(List.class, clazz));
        }
        Class<?>[] paramClass = new Class<?>[classes.length + 1];
        paramClass[0] = clazz;
        System.arraycopy(classes, 0, paramClass, 1, classes.length);
        return jsonArray.toJavaObject(ReflectUtils.getLoopWrapperType(List.class, paramClass));
    }

    public static String replaceJsonContent(String json, String... params) {
        if (params == null || params.length == 0) {
            return json;
        }

        for (String param : params) {
            if (json.contains(param)) {
                int pos1 = json.indexOf(param);
                int length = param.length();
                String leftStr = json.substring(0, pos1 + length + 1);
                String rightStr = json.substring(pos1 + length + 1);

                int pos2 = rightStr.indexOf(",");
                if (pos2 == -1) {
                    pos2 = rightStr.indexOf("}");
                }
                String rightStr2 = rightStr.substring(pos2);
                json = leftStr + ":\"(替代显示内容)\"" + rightStr2;
            }
        }
        return json;
    }

    public static <T> T convert2bean(Object obj, Class<T> clazz) {
        String json = toString(obj);
        return parseObject(json, clazz);
    }

    public static Dict parseDict(String text) {
        if (StringUtils.isBlank(text)) {
            return null;
        }
        try {
            return OBJECT_MAPPER.readValue(text, OBJECT_MAPPER.getTypeFactory().constructType(Dict.class));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toJsonString(Object object) {
        if (ObjectUtil.isNull(object)) {
            return null;
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}
