package com.icetech.common.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.icetech.common.exception.JsonException;
import lombok.extern.slf4j.Slf4j;

import java.util.Collection;
import java.util.Map;

/**
 * @deprecated 使用 {@link JsonUtils }
 */
@Slf4j
@Deprecated
public class JsonTools {
    /**
     * ObjectMapper
     */
    private static final ObjectMapper OBJECT_MAPPER;

    static {
        OBJECT_MAPPER = new ObjectMapper();
        // 设置输入时忽略在JSON字符串中存在但Java对象实际没有的属性
        OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        // 空对象不要抛出异常
        OBJECT_MAPPER.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }

    /**
     * 工具类，防止被实例化
     */
    private JsonTools() {
    }

    /**
     * 转换对象为字符串
     * @deprecated 使用 {@link JsonUtils#toString(Object)}
     */
    @Deprecated
    public static String toString(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        } catch (JsonProcessingException e) {
            throw new JsonException(e);
        }
    }

    /**
     * 将字符串转换为Bean对象
     * @deprecated 使用 {@link JsonUtils#parseObject(String, Class, Class...)}
     */
    @Deprecated
    public static <T> T toBean(String json, Class<T> classz) {
        if (json == null) {
            return null;
        }
        try {
            return OBJECT_MAPPER.readValue(json, classz);
        } catch (JsonProcessingException e) {
            throw new JsonException(e);
        }
    }

    /**
     * 转换对象为Bean，通过JavaType定义复杂对象
     * @deprecated 使用 {@link JsonUtils#parseObject(String, Class, Class...)}
     */
    @Deprecated
    public static <T> T toBean(String json, JavaType javaType) {
        if (json == null) {
            return null;
        }
        try {
            return OBJECT_MAPPER.readValue(json, javaType);
        } catch (JsonProcessingException e) {
            throw new JsonException(e);
        }
    }

    /**
     * 转换对象为Bean，通过JavaType定义复杂对象
     * @deprecated 使用 {@link JsonUtils#parseObject(String, Class, Class...)}
     */
    @Deprecated
    public static <T> T toBean(String json, TypeReference<T> typeReference) {
        if (json == null) {
            return null;
        }
        try {
            return OBJECT_MAPPER.readValue(json, typeReference);
        } catch (JsonProcessingException e) {
            throw new JsonException(e);
        }
    }


    /**
     * 构造Collection类型的JavaType对象
     */
    @Deprecated
    public static JavaType createJavaType(Class<? extends Collection<?>> collectionClass, Class<?> elementClass) {
        return OBJECT_MAPPER.getTypeFactory().constructCollectionType(collectionClass, elementClass);
    }


    /**
     * 构造Map类型的JavaType对象
     */
    @Deprecated
    public static JavaType createJavaType(Class<? extends Map<?, ?>> mapClass, Class<?> keyClass, Class<?> valueClass) {
        return OBJECT_MAPPER.getTypeFactory().constructMapType(mapClass, keyClass, valueClass);
    }


    /**
     * 通过获取TypeFactory从而构建更加复杂的JavaType类型
     */
    @Deprecated
    public static TypeFactory getTypeFactory() {
        return OBJECT_MAPPER.getTypeFactory();
    }


    /**
     * 替换json串中内容较长的部分
     * @deprecated 使用 {@link JsonUtils#replaceJsonContent(String, String...)}
     *
     * @param jsonStr
     * @param param   替换的关键参数
     */
    @Deprecated
    public static String replaceJsonContent(String jsonStr, String param) {
        if (jsonStr.contains(param)) {
            int pos1 = jsonStr.indexOf(param);
            int length = param.length();
            String leftStr = jsonStr.substring(0, pos1 + length + 1);
            String rightStr = jsonStr.substring(pos1 + length + 1, jsonStr.length());

            int pos2 = rightStr.indexOf(",");
            if (pos2 == -1) {
                pos2 = rightStr.indexOf("}");
            }
            String rightStr2 = rightStr.substring(pos2, rightStr.length());
            jsonStr = leftStr + ":\"(替代显示内容)\"" + rightStr2;
        }
        return jsonStr;
    }

    /**
     * 替换json串中内容较长的部分
     * @deprecated 使用 {@link JsonUtils#replaceJsonContent(String, String...)}
     *
     * @param jsonStr
     * @param paramArr   替换的关键参数
     */
    @Deprecated
    public static String replaceJsonContent(String jsonStr, String[] paramArr) {
        for (String param : paramArr) {
            jsonStr = replaceJsonContent(jsonStr, param);
        }
        return jsonStr;
    }
}
