package com.icetech.common.validator;

import com.icetech.common.annotation.AnyOneNotNull;
import com.icetech.common.annotation.NotNull;
import com.icetech.common.utils.StringUtils;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Description : 参数校验类
 * @author fangct
 * @since 1.0
 */
@Slf4j
public class Validator {
    //关系表达式关键字
    private static final String AND = "AND";
    private static final String OR = "OR";
    private static final String[] RELATION_TARGET_KEY = {" and "," or "};
    private static final String[] RELATION_REPLACEMENT_KEY = {" AND "," OR "};
    private static final String EQUAL_EXPRESSION = "==";

    public static boolean validate(Object instance) {
        if (instance == null){
            return false;
        }
        Class clz = instance.getClass();// 得到类对象
        Field[] fs = clz.getDeclaredFields();//得到属性集合

        try {
            return validate(clz, instance, fs);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return false;
        }
    }

    private static boolean validate(Class clz, Object instance, Field[] fs) throws IllegalAccessException, NoSuchFieldException {
        StringBuffer msgString = new StringBuffer("<参数校验> 校验失败，");
        /**
         * 任一必填处理使用参数
         */
        //key为group名，当前属性值不为空则为true，否则为false
        Map<String, Boolean> resultMap = new HashMap<String, Boolean>();
        //key为group名，value为相同group的属性名
        Map<String, String> msgTemp = new HashMap<String, String>();
        boolean anyOneNotNullFlag = true;

        /**
         * 必填处理使用参数
         */
        StringBuffer propertyTemp = new StringBuffer("必填参数：");
        boolean notNullFlag = true;
        //遍历属性
        for (Field field : fs) {
            // 设置属性是可以访问的(私有的也可以)
            field.setAccessible(true);

            NotNull notNull = field.getAnnotation(NotNull.class);
            AnyOneNotNull anyOneNotNull = field.getAnnotation(AnyOneNotNull.class);
            if(anyOneNotNull != null) {
                //暂时没有使用该注解
                dealAnyOneNotNull(instance, resultMap, msgTemp, field, anyOneNotNull);
            }else if(notNull != null) {
                //tg：是否通过参数校验
                boolean tg = dealNotNull(clz, instance, notNull, field, propertyTemp);
                if (!tg){
                    notNullFlag = false;
                }

            }
        }
        StringBuffer stringBuffer = new StringBuffer("任一必填参数：");
        List<String> keys = new ArrayList<String>(msgTemp.keySet());
        for (int i = 0; i < keys.size(); i++) {
            String key = keys.get(i);
            String value = msgTemp.get(key);
            stringBuffer.append("[").append(value).append("]").append(", ");
        }
        if (msgTemp.size() > 0){
            anyOneNotNullFlag = false;
            msgString.append(stringBuffer.toString());
        }

        if (!notNullFlag){
            msgString.append(propertyTemp.toString());
        }

        //最后的校验结果
        boolean finalRes = notNullFlag && anyOneNotNullFlag;
        if (!finalRes){
            log.info(msgString.toString());
        }
        return finalRes;
    }

    /**
     * 处理“任一必填”的校验
     * @param instance
     * @param resultMap
     * @param msgTemp
     * @param field
     * @param anyOneNotNull
     * @throws IllegalAccessException
     */
    private static void dealAnyOneNotNull(Object instance, Map<String, Boolean> resultMap, Map<String, String> msgTemp, Field field, AnyOneNotNull anyOneNotNull) throws IllegalAccessException {
        String group = anyOneNotNull.group();
        if (StringUtils.isNotBlankOrNullChar(group)) {
            String newGroupStr = group.trim();
            Object fieldValue = field.get(instance);
            Boolean aBoolean = resultMap.get(newGroupStr);
            if (aBoolean == null || !aBoolean){
                if (fieldValue == null) {
                    String msg = msgTemp.get(newGroupStr);
                    if (msg == null){
                        msgTemp.put(newGroupStr, field.getName());
                    }else{
                        msgTemp.put(newGroupStr, msg + " | " + field.getName());
                    }
                    resultMap.put(newGroupStr, false);
                }else{
                    msgTemp.remove(newGroupStr);
                    resultMap.put(newGroupStr, true);
                }
            }
        }
    }

    /**
     * 处理“必传”参数的校验
     * 条件表达式暂时只支持中有一种关系表达式的情况（要么全部是AND，要么全部是OR），
     * 不支持既有AND 又有OR的写法
     * @param clz
     * @param instance
     * @param t
     * @param field
     * @param propertyTemp
     * @throws NoSuchFieldException
     * @throws IllegalAccessException
     */
    private static boolean dealNotNull(Class clz, Object instance, NotNull t, Field field, StringBuffer propertyTemp) throws NoSuchFieldException, IllegalAccessException {
        boolean flag = true;
        String condition = t.condition();
        if (StringUtils.isNotBlankOrNullChar(condition)) {
            String newConditionStr = condition.trim();
            if (newConditionStr.contains(" and ") || newConditionStr.contains(" AND ")
                    || newConditionStr.contains(" or ") || newConditionStr.contains(" OR ") ){
                for (int i = 0; i < RELATION_TARGET_KEY.length; i++) {
                    newConditionStr = newConditionStr.replace(RELATION_TARGET_KEY[i], RELATION_REPLACEMENT_KEY[i]);
                }
                log.debug("<参数校验> 替换大写后的newConditionStr：{}", newConditionStr);
                if (newConditionStr.contains(AND)) {
                    String[] andArr = newConditionStr.split(AND);
                    for (String andStr : andArr) {
                        String[] equalArr = andStr.split(EQUAL_EXPRESSION);
                        String conName = equalArr[0].trim();
                        String conValue = equalArr[1].trim();

                        Field nameField = clz.getDeclaredField(conName);
                        nameField.setAccessible(true);
                        Object fieldValue = nameField.get(instance);
                        if (!conValue.equals(fieldValue)) {
                            if (conValue.startsWith("*")){
                                String temp = conValue.substring(1);
                                if (String.valueOf(fieldValue).endsWith(temp)){
                                    continue;
                                }
                            }
                            flag = false;
                            break;
                        }
                    }
                } else {
                    String[] orArr = newConditionStr.split(OR);
                    for (int j=0;j<orArr.length;j++) {
                        String orStr = orArr[j];
                        String[] equalArr = orStr.split(EQUAL_EXPRESSION);
                        String conName = equalArr[0].trim();
                        String conValue = equalArr[1].trim();

                        Field nameField = clz.getDeclaredField(conName);
                        nameField.setAccessible(true);
                        Object fieldValue = nameField.get(instance);
                        if (conValue.equals(fieldValue)) {
                            break;
                        }else if(j == orArr.length -1){
                            flag = false;
                        }else{
                            if (conValue.startsWith("*")){
                                String temp = conValue.substring(1);
                                if (String.valueOf(fieldValue).endsWith(temp)){
                                    break;
                                }
                            }
                        }
                    }
                }
            }else{
                String[] equalArr = newConditionStr.split(EQUAL_EXPRESSION);
                String conName = equalArr[0].trim();
                String conValue = equalArr[1].trim();

                Field nameField = clz.getDeclaredField(conName);
                nameField.setAccessible(true);
                Object fieldValue = nameField.get(instance);
                if (!conValue.equals(fieldValue)) {
                    if (conValue.startsWith("*")){
                        String temp = conValue.substring(1);
                        if (!String.valueOf(fieldValue).endsWith(temp)){
                            flag = false;
                        }
                    }else{
                        flag = false;
                    }
                }
            }
        }
        if (flag){
            Object val = field.get(instance);// 得到此属性的值
            if (val == null) {
                propertyTemp.append(field.getName() + ",");
                return false;
            }
        }
        return true;
    }
}
