package com.icetech.common.utils;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class FileTools {

    /**
     * 读取zip文件中制定文件的内容
     *
     * @param zipFile      目标zip文件对象
     * @param readFileName 目标读取文件名字
     * @return 文件内容
     * @throws ZipException
     * @throws IOException
     */
    @SuppressWarnings("unchecked")
    public static List<String[]> getZipFileContent(File zipFile, String readFileName) throws ZipException, IOException {
        List<String[]> resultList = new LinkedList<>();

        ZipFile zip = new ZipFile(zipFile, Charset.forName("GBK"));
        Enumeration<? extends ZipEntry> entries = zip.entries();

        ZipEntry ze;
        // 枚举zip文件内的文件/
        while (entries.hasMoreElements()) {
            ze = entries.nextElement();
            // 读取目标对象
            if (ze.getName().contains(readFileName)) {
                try (Scanner scanner = new Scanner(zip.getInputStream(ze), "GBK")) {
                    while (scanner.hasNextLine()) {
                        String line = scanner.nextLine();
                        //log.info(new String(line));
                        String[] lineArr = line.split(",");
                        resultList.add(lineArr);
                    }
                }
            }
        }
        zip.close();

        return resultList;
    }

    /**
     * 从网络Url中下载文件
     * @deprecated 使用 {@link org.apache.commons.io.IOUtils#toByteArray(URL)}
     *
     * @param urlStr
     * @throws IOException
     */
    @Deprecated
    public static byte[] downLoadFromUrl(String urlStr) throws IOException {
        URL url = new URL(urlStr);
        //add by fangct on 20170815 设置代理服务
        //Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ProxyConstants.ProxyHost, ProxyConstants.ProxyPort));
        HttpURLConnection conn = (HttpURLConnection) url.openConnection();
        //设置超时间为X秒
        conn.setConnectTimeout(1000);
        //防止屏蔽程序抓取而返回403错误
        conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");

        //得到输入流
        try (InputStream inputStream = conn.getInputStream()) {
            //获取自己数组
            byte[] getData = readInputStream(inputStream);
            return getData;
        }
    }


    /**
     * 从输入流中获取字节数组
     * @deprecated 使用 {@link org.apache.commons.io.IOUtils#toByteArray(InputStream)}
     *
     * @param inputStream
     * @return
     * @throws IOException
     */
    public static byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream()) {
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            bos.flush();
            return bos.toByteArray();
        }
    }

    /**
     * 从链接下载文件并返回
     *
     * @param url
     * @param fileName
     * @return
     * @throws IOException
     */
    public static File getFileFromUrl(String url, String fileName) throws IOException {
        byte[] bytes = IOUtils.toByteArray(new URL(url));
        String filePath = System.getProperty("java.io.tmpdir") + File.separator + fileName;
        File saveFile = new File(filePath);
        FileUtils.writeByteArrayToFile(saveFile, bytes);
        return saveFile;
    }

    /**
     * 从链接下载文件并返回
     *
     * @param url
     * @param fileName
     * @return
     * @throws IOException
     */
    public static File getFileFromUrl(String url, String filePath, String fileName) throws IOException {
        byte[] bytes = IOUtils.toByteArray(new URL(url));
        File saveFile = new File(filePath + File.separator + fileName);
        FileUtils.writeByteArrayToFile(saveFile, bytes);
        return saveFile;
    }

    /**
     * @deprecated {@link org.apache.commons.io.FileUtils#writeByteArrayToFile(File, byte[])}
     *
     * @param buffer
     * @param filePath
     */
    @Deprecated
    public static void bytesToFile(byte[] buffer, final String filePath) throws IOException {
        File file = new File(filePath);
        FileUtils.writeByteArrayToFile(file, buffer);
    }

    /**
     * 文件转base64
     * @deprecated {@link Base64Tools#encodeBase64String(File)}
     *
     * @param file
     * @return
     * @throws IOException
     */
    @Deprecated
    public static String encodeBase64File(File file) throws IOException {
        return Base64Tools.encodeBase64String(file);
    }

    /**
     * 处理Base64解码并输出流
     *
     * @param base64
     * @param out
     * @return 写入大小
     */
    public static int base64ToImageOutput(String base64, OutputStream out) throws IOException {
        if (StringUtils.isBlank(base64)) { // 图像数据为空
            return 0;
        }
        return IOUtils.copy(new ByteArrayInputStream(Base64Tools.decodeBase64(base64)), out);
    }

    /**
     * 处理Base64解码并写图片到指定位置
     *
     * @param base64 图片Base64数据
     * @param path   图片保存路径
     * @return 写入大小
     */
    public static int base64ToImageFile(String base64, String path) throws FileNotFoundException, IOException {
        // 对字节数组字符串进行Base64解码并生成图片
        // 生成jpeg图片
        OutputStream out = new FileOutputStream(path);
        return base64ToImageOutput(base64, out);
    }
}
