package com.icetech.common.utils;

import com.icetech.common.domain.request.BaseRequest;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.*;

@Slf4j
public class SignTools {
    /**
     * MD5验签
     * @param baseRequest 验签参数
     * @param key 密钥
     * @return
     */
    public static boolean verifyMD5Sign(BaseRequest baseRequest , String key){
        String sign = "";
        String mySign = "";
        String linkString = "";
        try {
            Map<String, Object> map = SignTools.convertMap(baseRequest);
            sign = (String) map.get("sign");
            map.remove("sign");
            linkString = getSignContent(map, key);
            mySign = DigestUtils.md5Hex(linkString).toUpperCase();

            if (sign.equals(mySign)){
                return true;
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        log.info("<签名校验> MD5验签不通过，md5的字符串：{}，sign：{}，mySign：{}", linkString, sign, mySign);
        return false;
    }

    /**
     * MD5验签
     * @param baseRequest 验签参数
     * @param key 密钥
     * @return
     */
    public static boolean verifyMD5Sign(Object baseRequest , String key){
        String sign = "";
        String mySign = "";
        String linkString = "";
        try {
            Map<String, Object> map = SignTools.convertMap(baseRequest);
            sign = (String) map.get("sign");
            map.remove("sign");
            linkString = getSignContent(map, key);
            mySign = DigestUtils.md5Hex(linkString);

            if (sign.equalsIgnoreCase(mySign)){
                return true;
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        log.info("<签名校验> MD5验签不通过，md5的字符串：{}，sign：{}，mySign：{}", linkString, sign, mySign);
        return false;
    }

    /**
     * 生成MD5签名
     * @param sortedParams 已排序后的map参数
     * @param key
     * @return
     */
    public static String getMySign(Map<String, Object> sortedParams, String key) {
        String linkString = "";
        if(null != sortedParams && !sortedParams.isEmpty()) {
            linkString = getSignContent(sortedParams, key) ;
            log.debug("<签名校验> 参与签名生成的字符串为：{}", linkString);
            String mySign = null;
            try {
                mySign = DigestUtils.md5Hex(linkString).toUpperCase();
            } catch (Exception e) {
                log.error(e.getMessage(), e);
            }
            return mySign;
        }else{
            return null;
        }
    }

    /**
     *得到签名内容
     * @param sortedParams
     * @return
     */
    public static String getSignContent(Map<String, Object> sortedParams, String secretKey) {
        StringBuffer content = new StringBuffer();
        List<String> keys = new ArrayList<String>(sortedParams.keySet());
        Collections.sort(keys);
        int index = 0;
        for (int i = 0; i < keys.size(); i++) {
            String key = keys.get(i);
            Object value = sortedParams.get(key);
            if (value != null && String.valueOf(value).length() > 0) {
                content.append((index == 0 ? "" : "&") + key + "=" + value);
                index++;
            }
        }
        content.append("&key=" + secretKey);
        return content.toString();
    }

    /**
     * map转有序gson
     * @param map
     */
    public static String map2SortJSON(Map<String, Object> map) {
        TreeMap<String, Object> treeMap = map instanceof TreeMap ? (TreeMap<String, Object>) map : new TreeMap<>(map);
        return JsonUtils.toString(treeMap);
    }

    /**
     * 将一个 JavaBean 或 Map对象中的bizContent元素转换成json后放入map返回
     *
     * @param bean
     *            要转化的JavaBean 对象
     * @return 转化出来的 Map 对象
     * @throws IntrospectionException
     *             如果分析类属性失败
     * @throws IllegalAccessException
     *             如果实例化 JavaBean 失败
     * @throws InvocationTargetException
     *             如果调用属性的 setter 方法失败
     */
    public static Map<String, Object> convertMap(Object bean) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        Map<String, Object> returnMap = new LinkedHashMap<String, Object>();
        if (bean instanceof Map<?, ?>){
            Map<String, Object> tempMap = (Map) bean;
            List<String> keys = new ArrayList<String>(tempMap.keySet());
            for (int i = 0; i < keys.size(); i++) {
                String key = keys.get(i);
                Object value = tempMap.get(key);
                returnMap.put(key, value);
            }
            Object bizContent = returnMap.get("bizContent");
            if (bizContent != null){
                returnMap.put("bizContent", JsonUtils.toString(bizContent));
            }
        }else {
            Class type = bean.getClass();
            BeanInfo beanInfo = Introspector.getBeanInfo(type);

            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; i++) {
                PropertyDescriptor descriptor = propertyDescriptors[i];
                String propertyName = descriptor.getName();
                if (!propertyName.equals("class")) {
                    Method readMethod = descriptor.getReadMethod();
                    Object result = readMethod.invoke(bean);
                    if (result != null) {
                        if (result instanceof Map<?,?>){
                            result = JsonUtils.toString(result);
                        }else if (propertyName.equals("bizContent") && !(result instanceof String)){
                            result = JsonUtils.toString(result);
                        }
                        returnMap.put(propertyName, result);
                    }
                }
            }
        }
        return returnMap;
    }

    /**
     * 对封装的map或实体参数对象，排序、bizContent类型转换、签名
     * @param object
     * @param key
     * @return
     * @throws IllegalAccessException
     * @throws IntrospectionException
     * @throws InvocationTargetException
     */
    public static String sign(Object object, String key) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        Map<String, Object> map = SignTools.convertMap(object);
        return SignTools.getMySign(map, key);
    }

}
