/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.utils;

import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    private static final RequestConfig DEFAULT_REQUEST_CONFIG = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(30000).build();
    private static final Pattern CONTENT_TYPE_CHARSET_PATTERN = Pattern.compile("charset=([A-Za-z0-9-]+)$");

    public static String get(String url, String ... param) throws IOException {
        if (param != null && param.length > 0) {
            url = url + "?" + HttpUtils.buildUrlParam(param);
        }
        return HttpUtils.request((HttpUriRequest)new HttpGet(url));
    }

    public static String get(String url, Map<String, Object> params) throws IOException {
        if (params != null && !params.isEmpty()) {
            url = url + "?" + HttpUtils.buildUrlParam(params);
        }
        return HttpUtils.get(url, new String[0]);
    }

    public static String postForm(String url, String ... param) throws IOException {
        if (param != null && param.length > 0) {
            url = url + "?" + HttpUtils.buildUrlParam(param);
        }
        return HttpUtils.get(url, new String[0]);
    }

    public static String post(String url, Map<String, Object> params) throws IOException {
        if (params == null || params.isEmpty()) {
            return HttpUtils.postForm(url, new String[0]);
        }
        return HttpUtils.post(url, params.entrySet().stream().flatMap(param -> {
            if (param.getValue() == null) {
                return Stream.of(new BasicNameValuePair((String)param.getKey(), ""));
            }
            if (param.getValue().getClass().isArray()) {
                int length = Array.getLength(param.getValue());
                ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(length);
                for (int i = 0; i < length; ++i) {
                    Object value = Array.get(param.getValue(), i);
                    pairs.add(new BasicNameValuePair((String)param.getKey(), value == null ? "" : value.toString()));
                }
                return pairs.stream();
            }
            return Stream.of(new BasicNameValuePair((String)param.getKey(), param.getValue().toString()));
        }).collect(Collectors.toList()));
    }

    public static String post(String url, List<NameValuePair> params) throws IOException {
        HttpPost request = new HttpPost(url);
        if (params != null && !params.isEmpty()) {
            UrlEncodedFormEntity requestEntity = new UrlEncodedFormEntity(params, StandardCharsets.UTF_8);
            request.setEntity((HttpEntity)requestEntity);
            request.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=" + StandardCharsets.UTF_8);
        }
        return HttpUtils.request((HttpUriRequest)request);
    }

    /*
     * Exception decompiling
     */
    private static String request(HttpUriRequest request) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String buildUrlParam(Map<String, Object> params) {
        return params.entrySet().stream().map(param -> {
            String content = (String)param.getKey() + "=";
            if (param.getValue() != null) {
                if (param.getValue().getClass().isArray()) {
                    int length = Array.getLength(param.getValue());
                    StringJoiner joiner = new StringJoiner("&" + content);
                    for (int i = 0; i < length; ++i) {
                        Object value = Array.get(param.getValue(), i);
                        joiner.add(value == null ? "" : value.toString());
                    }
                    content = content + joiner.toString();
                } else {
                    content = content + param.getValue();
                }
            }
            return content;
        }).collect(Collectors.joining("&"));
    }

    private static String buildUrlParam(String[] params) {
        StringJoiner joiner = new StringJoiner("&");
        for (int i = 0; i < params.length; ++i) {
            String name = params[i];
            String value = ++i < params.length ? params[i] : "";
            joiner.add(name + "=" + value);
        }
        return joiner.toString();
    }

    private static String getResponseCharset(HttpEntity entity) {
        String contentType;
        Matcher matcher;
        if (entity.getContentEncoding() != null && StringUtils.isNotBlank((CharSequence)entity.getContentEncoding().getValue())) {
            return entity.getContentEncoding().getValue();
        }
        if (entity.getContentType() != null && StringUtils.isNotBlank((CharSequence)entity.getContentType().getValue()) && (matcher = CONTENT_TYPE_CHARSET_PATTERN.matcher(contentType = entity.getContentType().getValue())).find()) {
            return matcher.group(1);
        }
        return StandardCharsets.UTF_8.name();
    }
}

