/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.domain.route;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.ValidationException;
import org.springframework.util.StringUtils;

public class GatewayPredicateDefinition {
    public static final String GEN_KEY = "_genkey_";
    private String name;
    private Map<String, String> args = new LinkedHashMap<String, String>();

    public GatewayPredicateDefinition() {
    }

    public GatewayPredicateDefinition(String text) throws ValidationException {
        int eqIdx = text.indexOf(61);
        if (eqIdx <= 0) {
            throw new ValidationException("Unable to parse GatewayPredicateDefinition text '" + text + "', must be of the form name=value");
        }
        this.setName(text.substring(0, eqIdx));
        String[] params = StringUtils.tokenizeToStringArray((String)text.substring(eqIdx + 1), (String)",");
        for (int i = 0; i < params.length; ++i) {
            this.args.put(GatewayPredicateDefinition.generateName(i), params[i]);
        }
    }

    public static String generateName(int i) {
        return GEN_KEY + i;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getArgs() {
        return this.args;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setArgs(Map<String, String> args) {
        this.args = args;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GatewayPredicateDefinition)) {
            return false;
        }
        GatewayPredicateDefinition other = (GatewayPredicateDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, String> this$args = this.getArgs();
        Map<String, String> other$args = other.getArgs();
        return !(this$args == null ? other$args != null : !((Object)this$args).equals(other$args));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GatewayPredicateDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, String> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        return result;
    }

    public String toString() {
        return "GatewayPredicateDefinition(name=" + this.getName() + ", args=" + this.getArgs() + ")";
    }
}

