/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.domain;

import com.icetech.common.domain.response.R;
import com.icetech.common.utils.LockPoolUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.UUIDTools;
import java.math.BigInteger;
import java.util.function.Function;
import java.util.function.Supplier;

public interface AsyncNotifyInterface {
    public static final String TOPIC_PREFIX = "asyncNotify";
    public static final String KEY_PREFIX = "notify:";
    public static final String key = NumberUtils.radix62(new BigInteger(UUIDTools.getUuid(), 16));
    public static final String topic = "asyncNotify." + key;

    public static String getTopic() {
        return topic;
    }

    public static String getKey() {
        return key;
    }

    public static String getMessageKey(String key) {
        return "notify:asyncNotify:" + key;
    }

    public void receiveMessage(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <R> R wait(String lock, Long waitTime, Supplier<R> supplier) {
        try {
            LockPoolUtils.add(lock);
            String string = lock;
            synchronized (string) {
                try {
                    lock.wait(waitTime == null ? 4000L : waitTime);
                }
                catch (InterruptedException e) {
                    R r = null;
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 6] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                    LockPoolUtils.remove(lock);
                    return r;
                }
            }
            R r = supplier.get();
            return r;
        }
        finally {
            LockPoolUtils.remove(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notify(String key, String topic, Function<String, R> supplier) {
        if (topic == null) {
            return;
        }
        String lock = LockPoolUtils.getLock(key);
        if (lock != null) {
            String string = lock;
            synchronized (string) {
                lock.notifyAll();
            }
        } else {
            supplier.apply(topic);
        }
    }
}

