/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.AntPathMatcher;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    private static final Pattern PATTERN_BLANK = Pattern.compile("\\s*|\t|\r|\n");
    private static final Pattern PATTERN_BRACE = Pattern.compile("\\{([^\\{\\}]+)\\}");

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        return String.valueOf(obj);
    }

    public static boolean isBlankOrNullChar(CharSequence content) {
        return StringUtils.isBlank((CharSequence)content) || StringUtils.equalsIgnoreCase((CharSequence)content, (CharSequence)"null");
    }

    public static boolean isNotBlankOrNullChar(CharSequence content) {
        return !StringUtils.isBlankOrNullChar(content);
    }

    public static String unicodeToChinese(String unicode) {
        StringBuilder out = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)unicode)) {
            for (int i = 0; i < unicode.length(); ++i) {
                out.append(unicode.charAt(i));
            }
        }
        return out.toString();
    }

    public static String stripNonValidXMLCharacters(String input) {
        if (StringUtils.isBlank((CharSequence)input)) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char current = input.charAt(i);
            if (current != '\t' && current != '\n' && current != '\r' && (current < ' ' || current > '\ud7ff') && (current < '\ue000' || current > '\ufffd')) continue;
            out.append(current);
        }
        return out.toString();
    }

    public static String replaceBlank(String str) {
        String dest = "";
        if (StringUtils.isNotBlank((CharSequence)str)) {
            Matcher m = PATTERN_BLANK.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static List<String> splitBySize(String value, int length) {
        char[] cs = value.toCharArray();
        StringBuilder result = new StringBuilder(length);
        ArrayList<String> resultList = new ArrayList<String>(value.getBytes().length / length + 1);
        int index = 0;
        for (char c : cs) {
            if ((index += String.valueOf(c).getBytes().length) >= length) {
                result.append(c);
                resultList.add(result.toString());
                result.delete(0, index);
                index = 0;
                continue;
            }
            result.append(c);
        }
        if (result.length() > 0) {
            resultList.add(result.toString());
        }
        return resultList;
    }

    public static String[] findBraceValue(String content) {
        Matcher m = PATTERN_BRACE.matcher(content);
        LinkedList<String> list = new LinkedList<String>();
        while (m.find()) {
            list.add(m.group(1));
        }
        String[] strings = new String[list.size()];
        return list.toArray(strings);
    }

    public static String toUpperCaseFirstOne(String content) {
        if (Character.isUpperCase(content.charAt(0))) {
            return content;
        }
        char[] ch = content.toCharArray();
        if (ch[0] >= 'a' && ch[0] <= 'z') {
            ch[0] = (char)(ch[0] - 32);
        }
        return new String(ch);
    }

    public static String toLowerCaseFirstOne(String content) {
        if (Character.isUpperCase(content.charAt(0))) {
            return content;
        }
        char[] ch = content.toCharArray();
        if (ch[0] >= 'a' && ch[0] <= 'z') {
            ch[0] = (char)(ch[0] + 32);
        }
        return new String(ch);
    }

    public static String getUrlParamsByMap(Map<String, Object> map) {
        if (map == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append(entry.getKey() + "=" + entry.getValue());
            sb.append("&");
        }
        String s = sb.toString();
        if (s.endsWith("&")) {
            s = org.apache.commons.lang3.StringUtils.substringBeforeLast((String)s, (String)"&");
        }
        return s;
    }

    public static int getInt(Object obj) {
        return StringUtils.getInt(obj, 0);
    }

    public static int getInt(Object obj, int defArg) {
        try {
            return Integer.parseInt(StringUtils.getString(obj, defArg));
        }
        catch (NumberFormatException e) {
            return defArg;
        }
    }

    public static String getString(Object obj, Object defStr) {
        return Objects.isNull(obj) ? String.valueOf(defStr) : String.valueOf(obj);
    }

    public static boolean containsAnyIgnoreCase(CharSequence cs, CharSequence ... searchCharSequences) {
        return StrUtil.containsAnyIgnoreCase((CharSequence)cs, (CharSequence[])searchCharSequences);
    }

    public static boolean matches(String str, List<String> strs) {
        if (StringUtils.isEmpty((CharSequence)str) || CollUtil.isEmpty(strs)) {
            return false;
        }
        for (String pattern : strs) {
            if (!StringUtils.isMatch(pattern, str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMatch(String pattern, String url) {
        AntPathMatcher matcher = new AntPathMatcher();
        return matcher.match(pattern, url);
    }
}

