/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.utils;

import com.icetech.common.constants.CommonConstants;
import com.icetech.common.utils.CodeTools;
import com.icetech.common.utils.StringUtils;
import org.slf4j.MDC;

public class Slf4jUtils {
    public static String putTraceId() {
        return Slf4jUtils.putTraceId(CodeTools.generateTradeId());
    }

    public static String putTraceId(String traceId) {
        if (StringUtils.isBlank((CharSequence)traceId)) {
            return Slf4jUtils.putTraceId();
        }
        MDC.put((String)CommonConstants.TRACE_ID_KEY, (String)traceId);
        return traceId;
    }

    public static String putTraceIdIfAbsent() {
        String traceId = Slf4jUtils.getTraceId();
        if (StringUtils.isBlank((CharSequence)traceId)) {
            return Slf4jUtils.putTraceId();
        }
        return traceId;
    }

    public static String putTraceIdIfAbsent(String traceId) {
        String trace = Slf4jUtils.getTraceId();
        if (StringUtils.isBlank((CharSequence)trace)) {
            return Slf4jUtils.putTraceId(traceId);
        }
        return trace;
    }

    @Deprecated
    public static String putTraceIdIfPresent() {
        String traceId = MDC.get((String)CommonConstants.TRACE_ID_KEY);
        if (StringUtils.isBlank((CharSequence)traceId)) {
            return Slf4jUtils.putTraceId();
        }
        return traceId;
    }

    public static String getTraceId() {
        return MDC.get((String)CommonConstants.TRACE_ID_KEY);
    }

    public static void removeTraceId() {
        MDC.remove((String)CommonConstants.TRACE_ID_KEY);
    }
}

