/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.utils;

import cn.hutool.core.util.ReflectUtil;
import com.icetech.common.utils.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class ReflectUtils
extends ReflectUtil {
    private static final Map<String, Type[]> INTERFACE_GENERIC_TYPES_CACHE = new ConcurrentHashMap<String, Type[]>(64);
    private static final Map<String, Type> WRAPPER_TYPE_CACHE = new ConcurrentHashMap<String, Type>(256);
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";

    public static <T> Type[] getInterfaceGenericTypes(Class<T> interfaceClass, T implement) {
        return ReflectUtils.getInterfaceGenericTypes(implement.getClass(), interfaceClass);
    }

    public static Type[] getInterfaceGenericTypes(Class<?> implementClass, Class<?> interfaceClass) {
        String cacheKey = interfaceClass.getTypeName() + ":" + implementClass.getTypeName();
        return INTERFACE_GENERIC_TYPES_CACHE.computeIfAbsent(cacheKey, key -> {
            Type[] typeArguments = ReflectUtils.getActualTypeArguments(implementClass.getGenericInterfaces(), interfaceClass);
            if (typeArguments == null) {
                List<Class<?>> superClasses = ReflectUtils.getAllSuperClasses(implementClass);
                Type[] types = (Type[])superClasses.stream().flatMap(superClass -> Stream.of(superClass.getGenericInterfaces())).toArray(Type[]::new);
                typeArguments = ReflectUtils.getActualTypeArguments(types, interfaceClass);
            }
            if (typeArguments == null) {
                throw new IllegalArgumentException("can not find " + implementClass.getName() + " Implements generic type");
            }
            return typeArguments;
        });
    }

    public static Type[] getActualTypeArguments(Type[] genericInterfaces, Class<?> interfaceClass) {
        Type[] typeArguments = null;
        for (Type type : genericInterfaces) {
            ParameterizedType parameterizedType;
            Type rawType;
            if (!(type instanceof ParameterizedType) || !((rawType = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) || !interfaceClass.isAssignableFrom((Class)rawType)) continue;
            typeArguments = parameterizedType.getActualTypeArguments();
        }
        return typeArguments;
    }

    public static <T> Type getInterfaceGenericTypeWrapper(Class<T> interfaceClass, T implement, Class<?> genericWrapperClass) {
        Type[] types = ReflectUtils.getInterfaceGenericTypes(interfaceClass, implement);
        return ReflectUtils.getWrapperType(genericWrapperClass, types);
    }

    public static <T> Type getInterfaceFirstGenericTypeWrapper(Class<T> interfaceClass, T implement, Class<?> genericWrapperClass) {
        Type[] types = ReflectUtils.getInterfaceGenericTypes(interfaceClass, implement);
        return ReflectUtils.getWrapperType(genericWrapperClass, types[0]);
    }

    public static <T> Type getInterfaceFirstGenericTypeWrapper(Class<T> interfaceClass, T implement, Class<?> genericWrapperClass, int index) {
        Type[] types = ReflectUtils.getInterfaceGenericTypes(interfaceClass, implement);
        return ReflectUtils.getWrapperType(genericWrapperClass, types[index]);
    }

    public static Type getWrapperType(Class<?> outClass, Class<?> ... innerClass) {
        return ReflectUtils.getWrapperType(true, outClass, innerClass);
    }

    public static Type getWrapperType(boolean cache, Class<?> outClass, Class<?> ... innerClass) {
        return ReflectUtils.getWrapperType(cache, outClass, (Type[])innerClass);
    }

    public static Type getWrapperType(Class<?> outClass, Type ... innerType) {
        return ReflectUtils.getWrapperType(true, outClass, innerType);
    }

    public static Type getWrapperType(boolean cache, Class<?> outClass, Type ... innerType) {
        if (!cache) {
            return ParameterizedTypeImpl.make(outClass, innerType, null);
        }
        String cacheKey = outClass.getTypeName() + "&" + Stream.of(innerType).map(Type::getTypeName).collect(Collectors.joining(","));
        return WRAPPER_TYPE_CACHE.computeIfAbsent(cacheKey, key -> ParameterizedTypeImpl.make(outClass, innerType, null));
    }

    public static Type getLoopWrapperType(Class<?> outClass, Class<?> ... innerClass) {
        if (innerClass == null) {
            throw new IllegalArgumentException("clazz must be not null");
        }
        if (innerClass.length == 1) {
            return ReflectUtils.getWrapperType(outClass, innerClass[0]);
        }
        Type type = ReflectUtils.getWrapperType(innerClass[innerClass.length - 2], innerClass[innerClass.length - 1]);
        for (int i = innerClass.length - 3; i >= 0; --i) {
            type = ReflectUtils.getWrapperType(innerClass[i], type);
        }
        return ReflectUtils.getWrapperType(outClass, type);
    }

    public static List<Class<?>> getAllSuperClasses(Class<?> clazz) {
        LinkedList list = new LinkedList();
        Class<?> superClass = clazz;
        while ((superClass = superClass.getSuperclass()) != null) {
            list.add(superClass);
        }
        return list;
    }

    public static <E> E invokeGetter(Object obj, String propertyName) {
        Object object = obj;
        for (String name : StringUtils.split((String)propertyName, (String)".")) {
            String getterMethodName = GETTER_PREFIX + StringUtils.capitalize((String)name);
            object = ReflectUtils.invoke((Object)object, (String)getterMethodName, (Object[])new Object[0]);
        }
        return (E)object;
    }

    public static <E> void invokeSetter(Object obj, String propertyName, E value) {
        Object object = obj;
        String[] names = StringUtils.split((String)propertyName, (String)".");
        for (int i = 0; i < names.length; ++i) {
            if (i < names.length - 1) {
                String getterMethodName = GETTER_PREFIX + StringUtils.capitalize((String)names[i]);
                object = ReflectUtils.invoke((Object)object, (String)getterMethodName, (Object[])new Object[0]);
                continue;
            }
            String setterMethodName = SETTER_PREFIX + StringUtils.capitalize((String)names[i]);
            Method method = ReflectUtils.getMethodByName(object.getClass(), (String)setterMethodName);
            ReflectUtils.invoke((Object)object, (Method)method, (Object[])new Object[]{value});
        }
    }
}

