/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.common.utils;

import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.MapUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsProxy {
    private static final Logger log = LoggerFactory.getLogger(HttpsProxy.class);
    private static final String METHOD_POST = "POST";
    private static final String DEFAULT_CHARSET = "utf-8";
    private static final int COOENT_TIMEOUT = 20000;
    private static final int READ_TIMEOUT = 20000;

    public static String doPost(String url, String params) throws Exception {
        String ctype = "application/json;charset=utf-8";
        byte[] content = new byte[]{};
        if (params != null) {
            content = params.getBytes(DEFAULT_CHARSET);
        }
        return HttpsProxy.doPost(url, ctype, content, 20000, 20000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, String ctype, byte[] content, int connectTimeout, int readTimeout) throws Exception {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
                SSLContext.setDefault(ctx);
                conn = HttpsProxy.getConnection(new URL(url), METHOD_POST, ctype);
                ((HttpsURLConnection)conn).setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
                conn.setConnectTimeout(connectTimeout);
                conn.setReadTimeout(readTimeout);
            }
            catch (Exception e) {
                log.error("GET_CONNECTOIN_ERROR, URL = " + url, (Throwable)e);
                throw e;
            }
            try {
                out = conn.getOutputStream();
                out.write(content);
                rsp = HttpsProxy.getResponseAsString(conn);
            }
            catch (IOException e) {
                log.error("REQUEST_RESPONSE_ERROR, URL = " + url, (Throwable)e);
                throw e;
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static HttpsURLConnection getConnection(URL url, String method, String ctype) throws IOException {
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "text/xml,text/javascript,text/html");
        conn.setRequestProperty("User-Agent", "stargate");
        conn.setRequestProperty("Content-Type", ctype);
        return conn;
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = HttpsProxy.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return HttpsProxy.getStreamAsString(conn.getInputStream(), charset);
        }
        String msg = HttpsProxy.getStreamAsString(es, charset);
        if (msg == null || "".equals(msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        throw new IOException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
            StringWriter writer = new StringWriter();
            char[] chars = new char[256];
            int count = 0;
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (ctype != null && !"".equals(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || pair[1] == null || "".equals(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    public static void main(String[] args) {
        HttpsProxy.addpark();
    }

    private static void addpark() {
        String url = "https://120.76.75.164:8443/unionapi/park/addpark";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("park_id", "100033");
        paramMap.put("name", "\u5317\u4eac\u4e0a\u5730\u4e09\u88579\u53f7\u9662\u505c\u8f66\u573a");
        paramMap.put("address", "\u5317\u4eac\u4e0a\u5730\u4e09\u88579\u53f7");
        paramMap.put("phone", "13899884433");
        paramMap.put("lng", "123.945839");
        paramMap.put("lat", "32.464176");
        paramMap.put("total_plot", "90");
        paramMap.put("empty_plot", "56");
        paramMap.put("union_id", "200099");
        paramMap.put("server_id", "800004");
        paramMap.put("rand", Math.random() + "");
        String ret = "";
        try {
            log.error(String.valueOf(paramMap));
            String linkParams = MapUtils.toSortedUrlParam(paramMap);
            log.error(linkParams);
            String sign = DigestUtils.md5Hex((String)(linkParams + "key=C9D76F91791B2B48")).toUpperCase();
            log.error(sign);
            paramMap.put("sign", sign);
            String param = JsonUtils.toString(paramMap);
            log.error(param);
            ret = HttpsProxy.doPost(url, param);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        log.error(ret);
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

