package com.icetech.common.utils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.*;

public class MapUtils {
    public static String toSortedUrlParam(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        TreeMap<String, Object> treeMap = null;
        if (map instanceof TreeMap) {
            treeMap = (TreeMap<String, Object>) map;
        } else {
            treeMap = new TreeMap<>(map);
        }

        List<String> params = new LinkedList<>();
        for (Map.Entry<String, Object> entry : treeMap.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map<?, ?> mapValue = (Map<?, ?>) value;
                value = JsonUtils.toString(mapValue);
            }
            if (value == null || String.valueOf(value).equals("")) {
                continue;
            }

            params.add(entry.getKey() + "=" + value);
        }

        return String.join("&", params);
    }

    /**
     * 将一个 JavaBean 对象转化为一个 Map
     *
     * @param bean
     *            要转化的JavaBean 对象
     * @return 转化出来的 Map 对象
     * @throws IntrospectionException
     *             如果分析类属性失败
     * @throws IllegalAccessException
     *             如果实例化 JavaBean 失败
     * @throws InvocationTargetException
     *             如果调用属性的 setter 方法失败
     */
    public static Map<String, Object> beanToMap(Object bean) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = bean.getClass();
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        Map<String, Object> returnMap = new HashMap<>(propertyDescriptors.length);
        for (int i = 0; i < propertyDescriptors.length; i++) {
            PropertyDescriptor descriptor = propertyDescriptors[i];
            String propertyName = descriptor.getName();
            if (!propertyName.equals("class")) {
                Method readMethod = descriptor.getReadMethod();
                Object result = readMethod.invoke(bean);
                if (result != null) {
                    returnMap.put(propertyName, result);
                } else {
                    returnMap.put(propertyName, "");
                }
            }
        }
        return returnMap;
    }
}
