package com.icetech.common.thread;

import lombok.extern.slf4j.Slf4j;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * Created by wangzw on 2017/3/11.
 */
@Slf4j
public class ThreadPoolExceptionHandler implements RejectedExecutionHandler {

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        log.error(String.format("线程池出现异常！线程池大小:%d，%s", executor.getQueue().size(), r.toString()));
    }
}
