package com.icetech.common.properties;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.ArrayList;
import java.util.List;

/**
 * Description 多租户配置
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wgy
 * @version 1.0 @Date 2023/11/2 9:51 AM
 */
@Getter
@Setter
@ConfigurationProperties(prefix = "ice.tenant")
public class TenantProperties {
    
    /**
     * 是否开启多租户
     */
    private Boolean enable = false;

    /**
     * 租户字段
     */
    private String tenantIdColumn = "tenant_id";

    /**
     * 配置包含的表名
     */
    private List<String> includeTables = new ArrayList<>();

    /**
     * 配置不进行多租户隔离的表名(和 includeTables 不可同时配置)
     */
    private List<String> ignoreTables = new ArrayList<>();

    /**
     * 配置不进行多租户隔离的sql
     * 需要配置mapper的全路径如：com.cloud.weishe.user.mapper.SysUserMapper.findList
     */
    private List<String> ignoreSqlList = new ArrayList<>();
}
