package com.icetech.common.domain.response;


import com.icetech.common.constants.CodeConstantsEnum;

import java.util.HashMap;

/**
 * @Auther: lisc
 * @Date: 2018/11/14 11:39
 * @Description: Response
 */
public class R extends HashMap<String,Object> {
    private static final long serialVersionUID = 1L;

    public R() {
        put("code", CodeConstantsEnum.SUCCESS.getCode());
        put("msg", CodeConstantsEnum.SUCCESS.getDesc());
    }

    public static R error() {
        return error(CodeConstantsEnum.ERROR.getCode(), CodeConstantsEnum.ERROR.getDesc());
    }

    public static R error(String msg) {
        return error(CodeConstantsEnum.ERROR.getCode(), msg);
    }

    public static R error(String code, String msg) {
        R r = new R();
        r.put("code", code);
        r.put("msg", msg);
        return r;
    }

    public static R error(CodeConstantsEnum codeConstantsEnum){
        R r = new R();
        r.put("code", codeConstantsEnum.getCode());
        r.put("msg", codeConstantsEnum.getDesc());
        return r;
    }

    public static R ok(String msg,Object data) {
        R r = new R();
        r.put("msg", msg);
        r.put("data",data);
        return r;
    }

    public static R ok(Object data) {
        R r = new R();
        r.put("data",data);
        return r;
    }
    public static Boolean isOk(R r) {
        return CodeConstantsEnum.SUCCESS.getCode().equals(r.get("code"));
    }
    public static R ok() {
        return new R();
    }

    @Override
    public R put(String key, Object value) {
        super.put(key, value);
        return this;
    }
}
