package com.icetech.common.domain;

import java.io.Serializable;

import lombok.Data;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
public class WebSocketMessage implements Serializable {
    public static final String UUID = "hcHu96xqMphsgwEYC63hS3O6HHX";
    public static final String OPERATE_HANDSHAKE = "handshake";
    public static final String OPERATE_OPEN = "open";
    public static final String OPERATE_CLOSE = "close";
    public static final String OPERATE_MESSAGE = "message";
    public static final String OPERATE_DISTINCT = "distinct";
    protected String uuid;
    /**
     * 模块
     */
    protected String module;
    /**
     * 通道
     */
    protected String channel;
    /**
     * 协议，1-WS, 2-IOT
     */
    protected Integer protocolType;
    /**
     * 版本号
     */
    protected String version;
    /**
     * 操作类型
     */
    protected String operate;
    /**
     * 请求内容
     */
    protected String content;
    protected String trace;
    /**
     * 源服务
     */
    protected String originalServer;
    /**
     * 源IP
     */
    protected String originalIp;

    public WebSocketMessage() {
        this.uuid = UUID;
    }

    public static WebSocketMessage buildClose(String module, String channel) {
        return new WebSocketMessage()
                .setModule(module)
                .setChannel(channel)
                .setOperate(OPERATE_CLOSE);
    }

    public static WebSocketMessage buildDistinct(String module, String channel, String ignore) {
        return new WebSocketMessage()
                .setModule(module)
                .setChannel(channel)
                .setOperate(OPERATE_DISTINCT)
                .setContent(ignore);
    }

    public static WebSocketMessage buildMessage(String module, String channel, String content) {
        return new WebSocketMessage()
                .setModule(module)
                .setChannel(channel)
                .setOperate(OPERATE_MESSAGE)
                .setContent(content);
    }
}
