package com.icetech.common.domain;

import lombok.Data;
import lombok.Getter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 消息发送类
 * @author wangzw
 */
@Data
public class SendObject<T> implements Serializable {
    private String type;
    private T t;

    /**
     *
     */
    public enum SendType {
        PARK_REPORT("PARK_REPORT","上报车场信息类型"),
        ENTER_REPORT("ENTER_REPORT","入场上报"),
        EXIT_REPORT("EXIT_REPORT","出厂上报"),
        PAY_REPORT("PAY_REPORT","支付财务上报"),
        ;
        private @Getter String type;
        private @Getter String desc;
        SendType(String type,String desc){
            this.type = type;
            this.desc = desc;
        }
        public static SendType getByType(String type){
            for(SendType sendType : values()){
                if (sendType.getType().equals(type)) {
                    //获取指定的枚举
                    return sendType;
                }
            }
            return null;
        }
    }

    /**
     * 车场信息上报
     */
    @Data
    public class ParkReport implements Serializable{

        /**
         * 车场唯一标识
         */
        private String parkCode;
        /**
         * 车场名称
         */
        private String parkName;
        /**
         *  0-百度；1-高德；2-其它
         */
        private String parkMap;
        /**
         * 车场经度
         */
        private String parkLat;
        /**
         * 车场纬度
         */
        private String parkLng;
        /**
         * 总车位数
         */
        private String totalPark;
        /**
         *经营许可证
         */
        private String businessLicense;
        /**
         * 注册总车位数
         */
        private String registParkNum;
        /**
         * 车场地址
         */
        private String address;
        /**
         * 车场所属城市编号
         */
        private String city;
        /**
         * 车场图片列表
         */
        private List<String> imgList;

        /**
         *
         */
        private List<SendObject.EnterOrExitInfo> enterOrExitInfos;
    }

    /**
     * 进出口详情信息
     */
    @Data
    public class EnterOrExitInfo implements Serializable{
        /**
         * 进出口编码
         */
        private String jckCode;
        /**
         * 进出口名称
         */
        private String jckName;
        /**
         *  0-百度；1-高德；2-其它
         */
        private String jckMap;
        /**
         * 进出口经度
         */
        private String jckLat;
        /**
         * 进出口纬度
         */
        private String jckLng;
    }

    /**
     * 入口通知上报
     */
    @Data
    public class EnterReport implements Serializable{
        /**
         * 车场唯一标识
         */
        private String parkCode;
        /**
         * 车场名称
         */
        private String parkName;
        /**
         * 进出口编码
         */
        private String jckCode;
        /**
         * 进出口名称
         */
        private String jckName;
        /**
         * 车牌号
         */
        private String plateNum;
        /**
         * 车牌类型
         */
        private String plateType;
        /**
         * 图片列表
         */
        private List<String> imgList;
        /**
         * 停车场车位数
         */
        private String  totalParkNum;
        /**
         * 在场车辆数
         */
        private String parkNum;
        /**
         * 剩余车位数
         */
        private String surplusNum;
        /**
         * 月卡标志 0 为非月卡，1 为月卡
         */
        private String type;
        /**
         * 手机号
         */
        private String mobileNum;
        /**
         * 代扣方式
         */
        private String payWay;
        /**
         * 车辆入场时间
         */
        private Date enterTime;
    }

    /**
     * 离场通知上报
     */
    @Data
    public class ExitReport implements Serializable{
        /**
         * 车场唯一标识
         */
        private String parkCode;
        /**
         * 车场名称
         */
        private String parkName;
        /**
         * 进出口编码
         */
        private String jckCode;
        /**
         * 进出口名称
         */
        private String jckName;
        /**
         * 车牌号
         */
        private String plateNum;
        /**
         * 车牌类型
         */
        private String plateType;
        /**
         * 图片列表
         */
        private List<String> imgList;
        /**
         * 停车场车位数
         */
        private String  totalParkNum;
        /**
         * 在场车位数
         */
        private String parkNum;
        /**
         * 剩余车位数
         */
        private String surplusNum;
        /**
         * 月卡标志 0 为非月卡，1 为月卡
         */
        private String type;
        /**
         * 停车时长
         */
        private String parkTime;
        /**
         * 车辆入场时间
         */
        private Date enterTime;
        /**
         * 出场时间
         */
        private Date exitTime;
    }
    /**
     * 支付财务上报
     * @author wangzw
     */
    @Data
    public class PayReport implements Serializable{
        /**
         * 车场唯一标识
         */
        private String parkCode;
        /**
         * 停车系统的用户id
         */
        private String userId;

        /**
         * 流水号
         */
        private String tradeNo;
        /**
         * 付款时间
         */
        private Date payTime;

        /**
         * 付款结果
         */
        private String payResult;

        /**
         * 付款金额
         */
        private String payMoney;
        /**
         * 支付详情
         */
        private List<SendObject.PayInfo> payInfos;
    }

    /**
     * 支付详情;
     */
    @Data
    public class PayInfo implements Serializable{
        /**
         * 支付方式
         */
        private String payType;
        /**
         * 支付描述
         */
        private String payDesc;
        /**
         * 支付流水号
         */
        private String tradeNo;
        /**
         * 支付金额
         */
        private String payMoney;
    }

    /**
     * 车牌类型
     */
    public enum PlateType {
        BIG_CAR("01","大型汽车,黄底黑字"),
        SMALL_CAR("02","小型汽车,蓝底白字"),
        BIG_NEW_CAR("51","大型新能源汽车号牌,左侧黄色右侧绿色双拼色底黑字"),
        SMALL_NEW_CAR("52","小型新能源汽车号牌,渐变绿底黑字"),
        OTHER("99", "其他号牌"),
        ;
        private @Getter String code;
        private @Getter String desc;

        PlateType(String code,String desc){
            this.code = code;
            this.desc = desc;
        }

    }
}
