package com.icetech.common.domain;

import lombok.*;

import java.io.Serializable;
import java.util.List;

/**
 * Created by wangzw on 17/1/4.
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
public class Page<T> implements Serializable {
    /**
     * 总数量
     */
    private Long total;
    /**
     * 总的页数
     */
    private Integer totalPage;
    /**
     * 总数据
     */
    private List<T> rows;

    public static <T> Page<T> instance(int totalPage, long total, List<T> row) {
        return new Page<>(total, totalPage, row);
    }
}
